/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Categories;
import org.dmg.pmml.CumulativeLinkFunctionType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.LinkFunctionType;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PCell;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PPCell;
import org.dmg.pmml.PPMatrix;
import org.dmg.pmml.ParamMatrix;
import org.dmg.pmml.ParameterCell;
import org.dmg.pmml.Predictor;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.GeneralRegressionModelManager;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class GeneralRegressionModelEvaluator
extends GeneralRegressionModelManager
implements Evaluator {
    private BiMap<FieldName, Predictor> factors = null;
    private BiMap<FieldName, Predictor> covariates = null;
    private Map<String, Map<String, Row>> ppMatrixMap = null;
    private Map<String, List<PCell>> paramMatrixMap = null;

    public GeneralRegressionModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
    }

    public BiMap<FieldName, Predictor> getFactorRegistry() {
        if (this.factors == null) {
            this.factors = super.getFactorRegistry();
        }
        return this.factors;
    }

    public BiMap<FieldName, Predictor> getCovariateRegistry() {
        if (this.covariates == null) {
            this.covariates = super.getCovariateRegistry();
        }
        return this.covariates;
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, Object> predictions;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        if (!generalRegressionModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)generalRegressionModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this, arguments);
        MiningFunctionType miningFunction = generalRegressionModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelManagerEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Map<FieldName, ?> arguments = this.getArguments(context);
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.size() != 1 || !ppMatrixMap.containsKey(null)) {
            throw new InvalidFeatureException((PMMLObject)this.getPPMatrix());
        }
        Map<String, Row> parameterPredictorRows = ppMatrixMap.get(null);
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        if (paramMatrixMap.size() != 1 || !paramMatrixMap.containsKey(null)) {
            throw new InvalidFeatureException((PMMLObject)this.getParamMatrix());
        }
        Iterable parameterCells = paramMatrixMap.get(null);
        Double result = this.computeDotProduct(parameterCells, parameterPredictorRows, arguments);
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case REGRESSION: {
                break;
            }
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ? extends ClassificationMap> evaluateClassification(ModelManagerEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = this.getModel();
        FieldName targetField = this.getTargetField();
        DataField dataField = this.getDataField(targetField);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
            }
        }
        List<String> targetCategories = ParameterUtil.getValidValues(dataField);
        if (targetCategories.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        Map<FieldName, ?> arguments = this.getArguments(context);
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        final Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        String targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        switch (modelType) {
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                Predicate<String> filter = new Predicate<String>(){

                    public boolean apply(String string) {
                        return !paramMatrixMap.containsKey(string);
                    }
                };
                LinkedHashSet targetReferenceCategories = Sets.newLinkedHashSet((Iterable)Iterables.filter(targetCategories, (Predicate)filter));
                if (targetReferenceCategories.size() != 1) {
                    throw new InvalidFeatureException((PMMLObject)this.getParamMatrix());
                }
                targetReferenceCategory = (String)Iterables.getOnlyElement((Iterable)targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        if (targetReferenceCategory != null && targetCategories.remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        ClassificationMap result = new ClassificationMap(ClassificationMap.Type.PROBABILITY);
        Double previousValue = null;
        for (int i = 0; i < targetCategories.size(); ++i) {
            Double value;
            String targetCategory = targetCategories.get(i);
            if (i < targetCategories.size() - 1) {
                Iterable parameterCells;
                Map<String, Row> parameterPredictorRow = ppMatrixMap.get(targetCategory);
                if (parameterPredictorRow == null) {
                    parameterPredictorRow = ppMatrixMap.get(null);
                }
                if (parameterPredictorRow == null) {
                    throw new InvalidFeatureException((PMMLObject)this.getPPMatrix());
                }
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        throw new InvalidFeatureException((PMMLObject)this.getParamMatrix());
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            throw new InvalidFeatureException((PMMLObject)this.getParamMatrix());
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            throw new InvalidFeatureException((PMMLObject)this.getParamMatrix());
                        }
                        parameterCells = Iterables.concat(interceptCells, (Iterable)parameterCells);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
                value = this.computeDotProduct(parameterCells, parameterPredictorRow, arguments);
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(value);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
            } else {
                value = 0.0;
                switch (modelType) {
                    case GENERAL_LINEAR: 
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(value);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = 1.0;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERAL_LINEAR: 
                case GENERALIZED_LINEAR: 
                case MULTINOMIAL_LOGISTIC: {
                    result.put(targetCategory, value);
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    if (previousValue == null) {
                        result.put(targetCategory, value);
                        break;
                    }
                    result.put(targetCategory, value - previousValue);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
                }
            }
            previousValue = value;
        }
        switch (modelType) {
            case GENERAL_LINEAR: 
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                result.normalizeValues();
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)modelType);
            }
        }
        return TargetUtil.evaluateClassification(Collections.singletonMap(targetField, result), context);
    }

    private Double computeDotProduct(Iterable<PCell> parameterCells, Map<String, Row> parameterPredictorRows, Map<FieldName, ?> arguments) {
        double sum = 0.0;
        for (PCell parameterCell : parameterCells) {
            Row parameterPredictorRow = parameterPredictorRows.get(parameterCell.getParameterName());
            Double x = parameterPredictorRow != null ? parameterPredictorRow.evaluate(arguments) : Double.valueOf(1.0);
            if (x == null) continue;
            sum += x * parameterCell.getBeta();
        }
        return sum;
    }

    private Double computeLink(Double value, EvaluationContext context) {
        Integer b;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Double a = GeneralRegressionModelEvaluator.getValue(DataType.DOUBLE, context.getArgument(generalRegressionModel.getOffsetVariable()), generalRegressionModel.getOffsetValue());
        if (a == null) {
            a = 0.0;
        }
        if ((b = GeneralRegressionModelEvaluator.getValue(DataType.INTEGER, context.getArgument(generalRegressionModel.getTrialsVariable()), generalRegressionModel.getTrialsValue())) == null) {
            b = 1;
        }
        Double d = generalRegressionModel.getLinkParameter();
        LinkFunctionType linkFunction = generalRegressionModel.getLinkFunction();
        if (linkFunction == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        switch (linkFunction) {
            case ODDSPOWER: 
            case POWER: {
                if (d != null) break;
                throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
            }
        }
        switch (linkFunction) {
            case CLOGLOG: {
                return (1.0 - Math.exp(-Math.exp(value + a))) * (double)b.intValue();
            }
            case IDENTITY: {
                return (value + a) * (double)b.intValue();
            }
            case LOG: {
                return Math.exp(value + a) * (double)b.intValue();
            }
            case LOGC: {
                return (1.0 - Math.exp(value + a)) * (double)b.intValue();
            }
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a))) * (double)b.intValue();
            }
            case ODDSPOWER: {
                if (d < 0.0 || d > 0.0) {
                    return 1.0 / (1.0 + Math.pow(1.0 + d * (value + a), -(1.0 / d))) * (double)b.intValue();
                }
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case POWER: {
                if (d < 0.0 || d > 0.0) {
                    return Math.pow(value + a, 1.0 / d) * (double)b.intValue();
                }
                return Math.exp(value + a) * (double)b.intValue();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)linkFunction);
    }

    private Double computeCumulativeLink(Double value, EvaluationContext context) {
        CumulativeLinkFunctionType cumulativeLinkFunction;
        GeneralRegressionModel generalRegressionModel = this.getModel();
        Double a = GeneralRegressionModelEvaluator.getValue(DataType.DOUBLE, context.getArgument(generalRegressionModel.getOffsetVariable()), generalRegressionModel.getOffsetValue());
        if (a == null) {
            a = 0.0;
        }
        if ((cumulativeLinkFunction = generalRegressionModel.getCumulativeLink()) == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        switch (cumulativeLinkFunction) {
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a)));
            }
            case CLOGLOG: {
                return 1.0 - Math.exp(-Math.exp(value + a));
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a)));
            }
            case CAUCHIT: {
                return 0.5 + 0.3183098861837907 * Math.atan(value + a);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum)cumulativeLinkFunction);
    }

    private Map<FieldName, ?> getArguments(EvaluationContext context) {
        BiMap<FieldName, Predictor> factors = this.getFactorRegistry();
        BiMap<FieldName, Predictor> covariates = this.getCovariateRegistry();
        LinkedHashMap result = Maps.newLinkedHashMap();
        Iterable predictors = Iterables.concat((Iterable)factors.values(), (Iterable)covariates.values());
        for (Predictor predictor : predictors) {
            FieldName name = predictor.getName();
            result.put(name, context.getArgument(name));
        }
        return result;
    }

    private Map<String, Map<String, Row>> getPPMatrixMap() {
        if (this.ppMatrixMap == null) {
            this.ppMatrixMap = this.parsePPMatrix();
        }
        return this.ppMatrixMap;
    }

    private Map<String, Map<String, Row>> parsePPMatrix() {
        Function<List<PPCell>, Row> rowBuilder = new Function<List<PPCell>, Row>(){
            private BiMap<FieldName, Predictor> factors;
            private BiMap<FieldName, Predictor> covariates;
            {
                this.factors = GeneralRegressionModelEvaluator.this.getFactorRegistry();
                this.covariates = GeneralRegressionModelEvaluator.this.getCovariateRegistry();
            }

            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    FieldName name = ppCell.getPredictorName();
                    Predictor factor = (Predictor)this.factors.get((Object)name);
                    if (factor != null) {
                        List<PPCell> factorCells = result.getFactorCells();
                        Categories categories = factor.getCategories();
                        if (categories != null) {
                            throw new UnsupportedFeatureException((PMMLObject)categories);
                        }
                        Matrix matrix = factor.getMatrix();
                        if (matrix != null) {
                            throw new UnsupportedFeatureException((PMMLObject)matrix);
                        }
                        factorCells.add(ppCell);
                        continue;
                    }
                    Predictor covariate = (Predictor)this.covariates.get((Object)name);
                    if (covariate != null) {
                        List<PPCell> covariateCells = result.getCovariateCells();
                        covariateCells.add(ppCell);
                        continue;
                    }
                    throw new InvalidFeatureException((PMMLObject)ppCell);
                }
                return result;
            }
        };
        PPMatrix ppMatrix = this.getPPMatrix();
        ListMultimap targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap result = Maps.newLinkedHashMap();
        Set targetCategoryEntries = GeneralRegressionModelEvaluator.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap predictorMap = Maps.newLinkedHashMap();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = GeneralRegressionModelEvaluator.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put(entry2.getKey(), rowBuilder.apply(entry2.getValue()));
            }
            result.put(entry.getKey(), predictorMap);
        }
        return result;
    }

    private Map<String, List<PCell>> getParamMatrixMap() {
        if (this.paramMatrixMap == null) {
            this.paramMatrixMap = this.parseParamMatrix();
        }
        return this.paramMatrixMap;
    }

    private Map<String, List<PCell>> parseParamMatrix() {
        ParamMatrix paramMatrix = this.getParamMatrix();
        ListMultimap targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return GeneralRegressionModelEvaluator.asMap(targetCategoryCells);
    }

    private static <V extends Number> V getValue(DataType dataType, Object argumentValue, V xmlValue) {
        if (argumentValue != null) {
            return (V)((Number)ParameterUtil.cast(dataType, argumentValue));
        }
        return xmlValue;
    }

    private static <C extends ParameterCell> Map<String, List<C>> asMap(ListMultimap<String, C> multimap) {
        return multimap.asMap();
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getParameterName();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByTargetCategory(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getTargetCategory();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupCells(List<C> cells, Function<C, String> function) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply((Object)cell), (Object)cell);
        }
        return result;
    }

    private static class Row {
        private List<PPCell> factorCells = Lists.newArrayList();
        private List<PPCell> covariateCells = Lists.newArrayList();

        private Row() {
        }

        public Double evaluate(Map<FieldName, ?> arguments) {
            List<PPCell> factorCells = this.getFactorCells();
            List<PPCell> covariateCells = this.getCovariateCells();
            if (factorCells.isEmpty() && covariateCells.isEmpty()) {
                return 1.0;
            }
            Boolean match = Row.calculateMatch(factorCells, arguments);
            Double product = Row.calculateProduct(covariateCells, arguments);
            if (covariateCells.isEmpty()) {
                if (match != null) {
                    return match != false ? 1.0 : 0.0;
                }
                return null;
            }
            if (factorCells.isEmpty()) {
                if (product != null) {
                    return product;
                }
                return null;
            }
            if (match != null && product != null) {
                return match != false ? product : 0.0;
            }
            return null;
        }

        public List<PPCell> getFactorCells() {
            return this.factorCells;
        }

        public List<PPCell> getCovariateCells() {
            return this.covariateCells;
        }

        private static Boolean calculateMatch(List<PPCell> ppCells, Map<FieldName, ?> arguments) {
            for (PPCell ppCell : ppCells) {
                Object value = arguments.get(ppCell.getPredictorName());
                if (value == null) {
                    return null;
                }
                boolean equals = ParameterUtil.equals(value, ppCell.getValue());
                if (equals) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        private static Double calculateProduct(List<PPCell> ppCells, Map<FieldName, ?> arguments) {
            Double result = null;
            for (PPCell ppCell : ppCells) {
                Object value = arguments.get(ppCell.getPredictorName());
                if (value == null) {
                    return null;
                }
                Double doubleValue = (Double)ParameterUtil.cast(DataType.DOUBLE, value);
                Double multiplicity = Double.valueOf(ppCell.getValue());
                if (result == null) {
                    result = Math.pow(doubleValue, multiplicity);
                    continue;
                }
                result = result * Math.pow(doubleValue, multiplicity);
            }
            return result;
        }
    }
}

