/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeatureType;
import org.dmg.pmml.RuleFeatureType;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasClusterAffinity;
import org.jpmml.evaluator.HasClusterId;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodes;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, Object> evaluate(Map<FieldName, ?> predictions, ModelManagerEvaluationContext context) {
        ModelManager<?> modelManager = context.getModelManager();
        LinkedHashMap frame = Maps.newLinkedHashMap();
        context.pushFrame(frame);
        Output output = modelManager.getOrCreateOutput();
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            FieldName targetField = outputField.getTargetField();
            if (targetField == null) {
                targetField = modelManager.getTargetField();
            }
            Object value = null;
            ResultFeatureType resultFeature = outputField.getFeature();
            if (resultFeature == null) {
                resultFeature = ResultFeatureType.PREDICTED_VALUE;
            }
            switch (resultFeature) {
                case PREDICTED_VALUE: 
                case PREDICTED_DISPLAY_VALUE: 
                case PROBABILITY: 
                case RESIDUAL: 
                case ENTITY_ID: 
                case CLUSTER_ID: 
                case AFFINITY: 
                case ENTITY_AFFINITY: 
                case CLUSTER_AFFINITY: 
                case REASON_CODE: 
                case RULE_VALUE: {
                    if (!predictions.containsKey(targetField)) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    value = predictions.get(targetField);
                    break;
                }
            }
            block3 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getPredictedValue(value);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    Target target = modelManager.getTarget(targetField);
                    value = OutputUtil.getPredictedDisplayValue(value, target);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException((PMMLObject)outputField);
                    }
                    value = ExpressionUtil.evaluate(expression, (EvaluationContext)context);
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(value, outputField);
                    break;
                }
                case RESIDUAL: {
                    Object expectedValue = context.getArgument(targetField);
                    if (expectedValue == null) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    DataField dataField = modelManager.getDataField(targetField);
                    OpType opType = dataField.getOptype();
                    switch (opType) {
                        case CONTINUOUS: {
                            value = OutputUtil.getContinuousResidual(value, expectedValue);
                            break block3;
                        }
                        case CATEGORICAL: {
                            value = OutputUtil.getCategoricalResidual(value, expectedValue);
                            break block3;
                        }
                    }
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)opType);
                }
                case ENTITY_ID: {
                    value = OutputUtil.getEntityId(value);
                    break;
                }
                case CLUSTER_ID: {
                    value = OutputUtil.getClusterId(value);
                    break;
                }
                case AFFINITY: 
                case ENTITY_AFFINITY: {
                    value = OutputUtil.getAffinity(value, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: {
                    value = OutputUtil.getClusterAffinity(value);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(value, outputField);
                    break;
                }
                case RULE_VALUE: {
                    value = OutputUtil.getRuleValue(value, outputField);
                    break;
                }
                case WARNING: {
                    value = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)resultFeature);
                }
            }
            FieldName name = outputField.getName();
            DataType dataType = outputField.getDataType();
            if (dataType != null && value != null) {
                value = ParameterUtil.cast(dataType, value);
            }
            frame.put(name, value);
        }
        context.popFrame();
        LinkedHashMap result = Maps.newLinkedHashMap(predictions);
        result.putAll(frame);
        return result;
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, Target target) {
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = (HasDisplayValue)object;
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null) {
            return targetValue.getDisplayValue();
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        if (!(object instanceof HasProbability)) {
            throw new EvaluationException();
        }
        HasProbability hasProbability = (HasProbability)object;
        return hasProbability.getProbability(outputField.getValue());
    }

    private static Double getContinuousResidual(Object object, Object expectedObject) {
        object = OutputUtil.getPredictedValue(object);
        Number value = (Number)object;
        Number expectedValue = (Number)expectedObject;
        return expectedValue.doubleValue() - value.doubleValue();
    }

    public static Double getCategoricalResidual(Object object, Object expectedObject) {
        if (!(object instanceof HasProbability)) {
            throw new EvaluationException();
        }
        HasProbability hasProbability = (HasProbability)object;
        object = OutputUtil.getPredictedValue(object);
        String value = (String)ParameterUtil.cast(DataType.STRING, object);
        boolean equals = ParameterUtil.equals(DataType.STRING, object, expectedObject);
        return (equals ? 1.0 : 0.0) - hasProbability.getProbability(value);
    }

    private static String getEntityId(Object object) {
        if (!(object instanceof HasEntityId)) {
            throw new EvaluationException();
        }
        HasEntityId hasEntityId = (HasEntityId)object;
        return hasEntityId.getEntityId();
    }

    private static String getClusterId(Object object) {
        if (!(object instanceof HasClusterId)) {
            throw new EvaluationException();
        }
        HasClusterId hasClusterId = (HasClusterId)object;
        return hasClusterId.getClusterId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        if (!(object instanceof HasAffinity)) {
            throw new EvaluationException();
        }
        HasAffinity hasAffinity = (HasAffinity)object;
        return hasAffinity.getAffinity(outputField.getValue());
    }

    public static Double getClusterAffinity(Object object) {
        if (!(object instanceof HasClusterAffinity)) {
            throw new EvaluationException();
        }
        HasClusterAffinity hasClusterAffinity = (HasClusterAffinity)object;
        return hasClusterAffinity.getClusterAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        if (!(object instanceof HasReasonCodes)) {
            throw new EvaluationException();
        }
        HasReasonCodes hasReasonCodes = (HasReasonCodes)object;
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        int index = rank - 1;
        List<String> reasonCodes = hasReasonCodes.getReasonCodes();
        if (index < reasonCodes.size()) {
            return reasonCodes.get(index);
        }
        return null;
    }

    public static Object getRuleValue(Object object, final OutputField outputField) {
        if (!(object instanceof HasRuleValues)) {
            throw new EvaluationException();
        }
        HasRuleValues hasRuleValues = (HasRuleValues)object;
        List<AssociationRule> associationRules = hasRuleValues.getRuleValues(outputField.getAlgorithm());
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                int order;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        order = left.getConfidence().compareTo(right.getConfidence());
                        break;
                    }
                    case SUPPORT: {
                        order = left.getSupport().compareTo(right.getSupport());
                        break;
                    }
                    case LIFT: {
                        order = left.getLift().compareTo(right.getLift());
                        break;
                    }
                    case LEVERAGE: {
                        order = left.getLeverage().compareTo(right.getLeverage());
                        break;
                    }
                    case AFFINITY: {
                        order = left.getAffinity().compareTo(right.getAffinity());
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)this.rankBasis);
                    }
                }
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)this.rankOrder);
            }
        };
        Collections.sort(associationRules, comparator);
        String isMultiValued = outputField.getIsMultiValued();
        if ("0".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank <= 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            int index = rank - 1;
            if (index < associationRules.size()) {
                AssociationRule associationRule = associationRules.get(index);
                return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField);
            }
            return null;
        }
        if ("1".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank < 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
            associationRules = associationRules.subList(0, size);
            ArrayList result = Lists.newArrayList();
            for (AssociationRule associationRule : associationRules) {
                result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField));
            }
            return result;
        }
        throw new InvalidFeatureException((PMMLObject)outputField);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField) {
        RuleFeatureType ruleFeature = outputField.getRuleFeature();
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on((char)',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                String id = associationRule.getId();
                if (id == null) {
                    BiMap<String, AssociationRule> associationRuleRegistry = hasRuleValues.getAssociationRuleRegistry();
                    id = (String)associationRuleRegistry.inverse().get((Object)associationRule);
                }
                return id;
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        ArrayList result = Lists.newArrayList();
        BiMap<String, Item> itemRegistry = hasRuleValues.getItemRegistry();
        BiMap<String, Itemset> itemsetRegistry = hasRuleValues.getItemsetRegistry();
        Itemset itemset = (Itemset)itemsetRegistry.get((Object)id);
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            Item item = (Item)itemRegistry.get((Object)itemRef.getItemRef());
            result.add(item.getValue());
        }
        return result;
    }
}

