/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TableUtil;
import org.jpmml.manager.UnsupportedFeatureException;

public class DiscretizationUtil {
    private DiscretizationUtil() {
    }

    public static FieldValue discretize(Discretize discretize, FieldValue value) {
        String result = DiscretizationUtil.discretize(discretize, value.asNumber().doubleValue());
        return FieldValueUtil.create(discretize.getDataType(), null, result);
    }

    public static String discretize(Discretize discretize, double value) {
        List bins = discretize.getDiscretizeBins();
        for (DiscretizeBin bin : bins) {
            Interval interval = bin.getInterval();
            if (!DiscretizationUtil.contains(interval, value)) continue;
            return bin.getBinValue();
        }
        return discretize.getDefaultValue();
    }

    public static boolean contains(Interval interval, double value) {
        Double left = interval.getLeftMargin();
        Double right = interval.getRightMargin();
        Interval.Closure closure = interval.getClosure();
        switch (closure) {
            case OPEN_CLOSED: {
                return DiscretizationUtil.greaterThan(value, left) && DiscretizationUtil.lessOrEqual(value, right);
            }
            case OPEN_OPEN: {
                return DiscretizationUtil.greaterThan(value, left) && DiscretizationUtil.lessThan(value, right);
            }
            case CLOSED_OPEN: {
                return DiscretizationUtil.greaterOrEqual(value, left) && DiscretizationUtil.lessThan(value, right);
            }
            case CLOSED_CLOSED: {
                return DiscretizationUtil.greaterOrEqual(value, left) && DiscretizationUtil.lessOrEqual(value, right);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)interval, (Enum)closure);
    }

    private static boolean lessThan(double value, Double reference) {
        return reference == null || Double.compare(value, reference) < 0;
    }

    private static boolean lessOrEqual(double value, Double reference) {
        return reference == null || Double.compare(value, reference) <= 0;
    }

    private static boolean greaterThan(double value, Double reference) {
        return reference == null || Double.compare(value, reference) > 0;
    }

    private static boolean greaterOrEqual(double value, Double reference) {
        return reference == null || Double.compare(value, reference) >= 0;
    }

    public static FieldValue mapValue(MapValues mapValues, Map<String, FieldValue> values) {
        List<Map<String, String>> rows;
        Map<String, String> row;
        DataType dataType = mapValues.getDataType();
        InlineTable table = mapValues.getInlineTable();
        if (table != null && (row = TableUtil.match(rows = TableUtil.parse(table), values)) != null) {
            String result = row.get(mapValues.getOutputColumn());
            if (result == null) {
                throw new EvaluationException((PMMLObject)mapValues);
            }
            return FieldValueUtil.create(dataType, null, result);
        }
        TableLocator tableLocator = mapValues.getTableLocator();
        if (tableLocator != null) {
            throw new UnsupportedFeatureException((PMMLObject)tableLocator);
        }
        return FieldValueUtil.create(dataType, null, mapValues.getDefaultValue());
    }
}

