/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class MeasureUtil {
    private MeasureUtil() {
    }

    public static boolean isDistance(Measure measure) {
        return measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof Chebychev || measure instanceof CityBlock || measure instanceof Minkowski;
    }

    public static Double evaluateDistance(ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<FieldValue> values, List<? extends Number> centerValues, List<Double> fieldWeights, Double adjustment) {
        double innerPower;
        double outerPower;
        Measure measure = comparisonMeasure.getMeasure();
        if (measure instanceof Euclidean) {
            outerPower = 2.0;
            innerPower = 2.0;
        } else if (measure instanceof SquaredEuclidean) {
            innerPower = 2.0;
            outerPower = 1.0;
        } else if (measure instanceof Chebychev || measure instanceof CityBlock) {
            outerPower = 1.0;
            innerPower = 1.0;
        } else if (measure instanceof Minkowski) {
            Minkowski minkowski = (Minkowski)measure;
            double p = minkowski.getPParameter();
            if (p < 0.0) {
                throw new InvalidFeatureException((PMMLObject)minkowski);
            }
            innerPower = outerPower = p;
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        ArrayList distances = Lists.newArrayList();
        for (int i = 0; i < clusteringFields.size(); ++i) {
            FieldValue value = values.get(i);
            if (value == null) continue;
            Double distance = MeasureUtil.evaluateInnerFunction(comparisonMeasure, clusteringFields.get(i), value.asNumber(), centerValues.get(i), fieldWeights.get(i), innerPower);
            distances.add(distance);
        }
        if (measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof CityBlock || measure instanceof Minkowski) {
            double sum = 0.0;
            for (Double distance : distances) {
                sum += distance.doubleValue();
            }
            return Math.pow(sum * adjustment, 1.0 / outerPower);
        }
        if (measure instanceof Chebychev) {
            Double max = (Double)Collections.max(distances);
            return max * adjustment;
        }
        throw new UnsupportedFeatureException((PMMLObject)measure);
    }

    private static double evaluateInnerFunction(ComparisonMeasure comparisonMeasure, ClusteringField clusteringField, Number x, Number y, Double weight, Double power) {
        double distance;
        CompareFunctionType compareFunction = clusteringField.getCompareFunction();
        if (compareFunction == null) {
            compareFunction = comparisonMeasure.getCompareFunction();
            switch (compareFunction) {
                case ABS_DIFF: 
                case DELTA: 
                case EQUAL: {
                    break;
                }
                case GAUSS_SIM: 
                case TABLE: {
                    throw new InvalidFeatureException((PMMLObject)comparisonMeasure);
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)comparisonMeasure, (Enum)compareFunction);
                }
            }
        }
        switch (compareFunction) {
            case ABS_DIFF: {
                distance = Math.abs(x.doubleValue() - y.doubleValue());
                break;
            }
            case GAUSS_SIM: {
                Double similarityScale = clusteringField.getSimilarityScale();
                if (similarityScale == null) {
                    throw new InvalidFeatureException((PMMLObject)clusteringField);
                }
                double z = x.doubleValue() - y.doubleValue();
                double s = similarityScale;
                distance = Math.exp(-Math.log(2.0) * Math.pow(z, 2.0) / Math.pow(s, 2.0));
                break;
            }
            case DELTA: 
            case EQUAL: {
                DataType dataType = TypeUtil.getResultDataType(TypeUtil.getDataType(x), TypeUtil.getDataType(y));
                boolean equals = TypeUtil.equals(dataType, x, y);
                if (CompareFunctionType.DELTA.equals((Object)compareFunction)) {
                    distance = !equals ? 1 : 0;
                    break;
                }
                distance = equals ? 1 : 0;
                break;
            }
            case TABLE: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringField, (Enum)compareFunction);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)clusteringField, (Enum)compareFunction);
            }
        }
        return weight * Math.pow(distance, power);
    }

    public static boolean isSimilarity(Measure measure) {
        return measure instanceof SimpleMatching || measure instanceof Jaccard || measure instanceof Tanimoto || measure instanceof BinarySimilarity;
    }
}

