/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TableUtil;
import org.junit.Assert;
import org.junit.Test;

public class TableUtilTest {
    @Test
    public void matchSingleColumn() {
        Map<String, String> first = TableUtilTest.createRow(new String[][]{{"value", "1"}, {"output", "first"}});
        Map<String, String> second = TableUtilTest.createRow(new String[][]{{"value", "2"}, {"output", "second"}});
        Map<String, String> third = TableUtilTest.createRow(new String[][]{{"value", "3"}, {"output", "third"}});
        List<Map> rows = Arrays.asList(first, second, third);
        Assert.assertEquals(first, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", "1"}})));
        Assert.assertEquals(second, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 2}})));
        Assert.assertEquals(third, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 3.0}})));
        Assert.assertEquals(null, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", "false"}})));
    }

    @Test
    public void matchMultipleColumns() {
        Map<String, String> firstTrue = TableUtilTest.createRow(new String[][]{{"value", "1"}, {"flag", "true"}, {"output", "firstTrue"}});
        Map<String, String> firstFalse = TableUtilTest.createRow(new String[][]{{"value", "1"}, {"flag", "false"}, {"output", "firstFalse"}});
        Map<String, String> secondTrue = TableUtilTest.createRow(new String[][]{{"value", "2"}, {"flag", "true"}, {"output", "secondTrue"}});
        Map<String, String> secondFalse = TableUtilTest.createRow(new String[][]{{"value", "2"}, {"flag", "false"}, {"output", "secondFalse"}});
        Map<String, String> thirdTrue = TableUtilTest.createRow(new String[][]{{"value", "3"}, {"flag", "true"}, {"output", "thirdTrue"}});
        Map<String, String> thirdFalse = TableUtilTest.createRow(new String[][]{{"value", "3"}, {"flag", "false"}, {"output", "thirdFalse"}});
        List<Map> rows = Arrays.asList(firstTrue, firstFalse, secondTrue, secondFalse, thirdTrue, thirdFalse);
        Assert.assertEquals(null, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", "1"}})));
        Assert.assertEquals(firstTrue, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", "1"}, {"flag", "true"}})));
        Assert.assertEquals(firstFalse, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", "1"}, {"flag", false}})));
        Assert.assertEquals(secondTrue, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 2}, {"flag", "true"}})));
        Assert.assertEquals(secondFalse, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 2}, {"flag", false}})));
        Assert.assertEquals(thirdTrue, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 3.0}, {"flag", "true"}})));
        Assert.assertEquals(thirdFalse, (Object)TableUtil.match(rows, TableUtilTest.createValues(new Object[][]{{"value", 3.0}, {"flag", false}})));
    }

    private static Map<String, String> createRow(String[][] strings) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (int i = 0; i < strings.length; ++i) {
            result.put(strings[i][0], strings[i][1]);
        }
        return result;
    }

    private static Map<String, FieldValue> createValues(Object[][] objects) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (int i = 0; i < objects.length; ++i) {
            result.put((String)objects[i][0], FieldValueUtil.create((Object)objects[i][1]));
        }
        return result;
    }
}

