/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TypeUtilTest {
    @Test
    public void cast() {
        Assert.assertEquals((Object)"1", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)"1"));
        Assert.assertEquals((Object)"1", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1.0));
        Assert.assertEquals((Object)"1.0", (Object)TypeUtil.cast((DataType)DataType.STRING, (Object)1.0));
        Assert.assertEquals((Object)1, (Object)TypeUtil.cast((DataType)DataType.INTEGER, (Object)1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)TypeUtil.cast((DataType)DataType.FLOAT, (Object)1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)TypeUtil.cast((DataType)DataType.FLOAT, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)1));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)TypeUtil.cast((DataType)DataType.DOUBLE, (Object)1.0));
    }

    @Test
    public void compareDateTime() {
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.DATE, (Object)TypeUtilTest.parseDate("1960-01-01"), (Object)TypeUtilTest.parseDate("1960-01-01")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.TIME, (Object)TypeUtilTest.parseTime("00:00:00"), (Object)TypeUtilTest.parseTime("00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.DATE_TIME, (Object)TypeUtilTest.parseDateTime("1960-01-01T00:00:00"), (Object)TypeUtilTest.parseDateTime("1960-01-01T00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.DATE_DAYS_SINCE_1960, (Object)TypeUtilTest.parseDaysSince1960("1960-01-01"), (Object)TypeUtilTest.parseDaysSince1960("1960-01-01")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.TIME_SECONDS, (Object)TypeUtilTest.parseSecondsSinceMidnight("00:00:00"), (Object)TypeUtilTest.parseSecondsSinceMidnight("00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TypeUtil.compare((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (Object)TypeUtilTest.parseSecondsSince1960("1960-01-01T00:00:00"), (Object)TypeUtilTest.parseSecondsSince1960("1960-01-01T00:00:00")) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void parseDaysSinceDate() {
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countDaysSince1960("1960-01-01"));
        Assert.assertEquals((long)1L, (long)TypeUtilTest.countDaysSince1960("1960-01-02"));
        Assert.assertEquals((long)31L, (long)TypeUtilTest.countDaysSince1960("1960-02-01"));
        Assert.assertEquals((long)-1L, (long)TypeUtilTest.countDaysSince1960("1959-12-31"));
        Assert.assertEquals((long)15796L, (long)TypeUtilTest.countDaysSince1960("2003-04-01"));
    }

    @Test
    public void parseSecondsSinceMidnight() {
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countSecondsSinceMidnight("0:00:00"));
        Assert.assertEquals((long)100L, (long)TypeUtilTest.countSecondsSinceMidnight("0:01:40"));
        Assert.assertEquals((long)200L, (long)TypeUtilTest.countSecondsSinceMidnight("0:03:20"));
        Assert.assertEquals((long)1000L, (long)TypeUtilTest.countSecondsSinceMidnight("0:16:40"));
        Assert.assertEquals((long)86400L, (long)TypeUtilTest.countSecondsSinceMidnight("24:00:00"));
        Assert.assertEquals((long)86401L, (long)TypeUtilTest.countSecondsSinceMidnight("24:00:01"));
        Assert.assertEquals((long)100000L, (long)TypeUtilTest.countSecondsSinceMidnight("27:46:40"));
        Assert.assertEquals((long)19410L, (long)TypeUtilTest.countSecondsSinceMidnight("05:23:30"));
    }

    @Test
    public void parseSecondsSinceDate() {
        Assert.assertEquals((long)0L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:00:00"));
        Assert.assertEquals((long)1L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:00:01"));
        Assert.assertEquals((long)60L, (long)TypeUtilTest.countSecondsSince1960("1960-01-01T00:01:00"));
        Assert.assertEquals((long)-1L, (long)TypeUtilTest.countSecondsSince1960("1959-12-31T23:59:59"));
        Assert.assertEquals((long)185403L, (long)TypeUtilTest.countSecondsSince1960("1960-01-03T03:30:03"));
    }

    @Test
    public void getDataType() {
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getDataType((Object)"value"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getDataType((Object)1));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getDataType((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtil.getDataType((Object)1.0));
    }

    @Test
    public void getResultDataType() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1.0, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1.0, 1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(Float.valueOf(1.0f), 1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtilTest.getResultDataType(Float.valueOf(1.0f), 1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)TypeUtilTest.getResultDataType(1, 1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtilTest.getResultDataType(1, Float.valueOf(1.0f)));
    }

    @Test
    public void getConstantDataType() {
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getConstantDataType((String)"1.0"));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)TypeUtil.getConstantDataType((String)"1.0E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1.0X"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)TypeUtil.getConstantDataType((String)"1"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)TypeUtil.getConstantDataType((String)"1X"));
    }

    private static LocalDate parseDate(String string) {
        return (LocalDate)TypeUtil.parse((DataType)DataType.DATE, (String)string);
    }

    private static LocalTime parseTime(String string) {
        return (LocalTime)TypeUtil.parse((DataType)DataType.TIME, (String)string);
    }

    private static LocalDateTime parseDateTime(String string) {
        return (LocalDateTime)TypeUtil.parse((DataType)DataType.DATE_TIME, (String)string);
    }

    private static int countDaysSince1960(String string) {
        DaysSinceDate period = TypeUtilTest.parseDaysSince1960(string);
        return period.intValue();
    }

    private static DaysSinceDate parseDaysSince1960(String string) {
        return (DaysSinceDate)TypeUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1960, (String)string);
    }

    private static int countSecondsSinceMidnight(String string) {
        SecondsSinceMidnight period = TypeUtilTest.parseSecondsSinceMidnight(string);
        return period.intValue();
    }

    private static SecondsSinceMidnight parseSecondsSinceMidnight(String string) {
        return (SecondsSinceMidnight)TypeUtil.parse((DataType)DataType.TIME_SECONDS, (String)string);
    }

    private static int countSecondsSince1960(String string) {
        SecondsSinceDate period = TypeUtilTest.parseSecondsSince1960(string);
        return period.intValue();
    }

    private static SecondsSinceDate parseSecondsSince1960(String string) {
        return (SecondsSinceDate)TypeUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (String)string);
    }

    private static DataType getResultDataType(Object left, Object right) {
        return TypeUtil.getResultDataType((DataType)TypeUtil.getDataType((Object)left), (DataType)TypeUtil.getDataType((Object)right));
    }
}

