/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.MiningModelManager;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class MiningModelEvaluator
extends MiningModelManager
implements Evaluator {
    private static final ModelEvaluatorFactory evaluatorFactory = ModelEvaluatorFactory.getInstance();

    public MiningModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public MiningModelEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        return ArgumentUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ?> predictions;
        MiningModel miningModel = this.getModel();
        if (!miningModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)miningModel);
        }
        EmbeddedModel embeddedModel = (EmbeddedModel)Iterables.getFirst((Iterable)miningModel.getContent(), null);
        if (embeddedModel != null) {
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(context);
                break;
            }
            default: {
                predictions = this.evaluateAny(context);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelManagerEvaluationContext context) {
        Double result;
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentation, segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        double sum = 0.0;
        double weightedSum = 0.0;
        for (SegmentResult segmentResult : segmentResults) {
            Object targetValue = EvaluatorUtil.decode(segmentResult.getTargetValue());
            Double value = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, targetValue);
            sum += value.doubleValue();
            weightedSum += segmentResult.getSegment().getWeight() * value;
        }
        switch (multipleModelMethod) {
            case SUM: {
                result = sum;
                break;
            }
            case AVERAGE: {
                result = sum / (double)segmentResults.size();
                break;
            }
            case WEIGHTED_AVERAGE: {
                result = weightedSum / (double)segmentResults.size();
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ?> evaluateClassification(ModelManagerEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentation, segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        ClassificationMap result = new ClassificationMap(ClassificationMap.Type.PROBABILITY);
        result.putAll(MiningModelEvaluator.countVotes(segmentation, segmentResults));
        result.normalizeValues();
        return TargetUtil.evaluateClassification(result, context);
    }

    private Map<FieldName, ?> evaluateClustering(ModelManagerEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentation, segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        ClassificationMap result = new ClassificationMap(ClassificationMap.Type.VOTE);
        result.putAll(MiningModelEvaluator.countVotes(segmentation, segmentResults));
        return Collections.singletonMap(this.getTargetField(), result);
    }

    private Map<FieldName, ?> evaluateAny(ModelManagerEvaluationContext context) {
        List<SegmentResult> segmentResults = this.evaluate(context);
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SELECT_FIRST: 
            case MODEL_CHAIN: {
                return this.dispatchSingleResult(segmentation, segmentResults);
            }
            case SELECT_ALL: {
                throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
    }

    private Map<FieldName, ?> dispatchSingleResult(Segmentation segmentation, List<SegmentResult> results) {
        if (results.size() < 1 || results.size() > 1) {
            throw new MissingResultException((PMMLObject)segmentation);
        }
        SegmentResult result = results.get(0);
        return result.getResult();
    }

    private static Map<String, Double> countVotes(Segmentation segmentation, List<SegmentResult> segmentResults) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        for (SegmentResult segmentResult : segmentResults) {
            Object targetValue = EvaluatorUtil.decode(segmentResult.getTargetValue());
            String category = TypeUtil.format(targetValue);
            Double vote = (Double)result.get(category);
            if (vote == null) {
                vote = 0.0;
            }
            switch (multipleModelMethod) {
                case MAJORITY_VOTE: {
                    vote = vote + 1.0;
                    break;
                }
                case WEIGHTED_MAJORITY_VOTE: {
                    vote = vote + segmentResult.getSegment().getWeight() * 1.0;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)segmentation, (Enum)multipleModelMethod);
                }
            }
            result.put(category, vote);
        }
        return result;
    }

    private List<SegmentResult> evaluate(EvaluationContext context) {
        MiningModel miningModel = this.getModel();
        ArrayList results = Lists.newArrayList();
        Segmentation segmentation = this.getSegmentation();
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        Model lastModel = null;
        MiningFunctionType miningFunction = miningModel.getFunctionName();
        List segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Predicate predicate = segment.getPredicate();
            if (predicate == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            Boolean status = PredicateUtil.evaluate(predicate, context);
            if (status == null || !status.booleanValue()) continue;
            Model model = segment.getModel();
            if (model == null) {
                throw new InvalidFeatureException((PMMLObject)segment);
            }
            switch (multipleModelMethod) {
                case MODEL_CHAIN: {
                    lastModel = model;
                    break;
                }
                default: {
                    if (miningFunction.equals((Object)model.getFunctionName())) break;
                    throw new InvalidFeatureException((PMMLObject)model);
                }
            }
            Evaluator evaluator = this.createEvaluator(model);
            FieldName targetField = evaluator.getTargetField();
            Map<FieldName, ?> result = evaluator.evaluate(context.getArguments());
            switch (multipleModelMethod) {
                case SELECT_FIRST: {
                    return Collections.singletonList(new SegmentResult(segment, targetField, result));
                }
                case MODEL_CHAIN: {
                    LinkedHashMap frame = Maps.newLinkedHashMap();
                    List outputFields = evaluator.getOutputFields();
                    for (FieldName outputField : outputFields) {
                        Object outputValue = result.get(outputField);
                        if (outputValue == null) {
                            throw new MissingFieldException(outputField, (PMMLObject)segment);
                        }
                        outputValue = EvaluatorUtil.decode(outputValue);
                        frame.put(outputField, outputValue);
                    }
                    context.pushFrame(frame);
                    results.clear();
                }
            }
            results.add(new SegmentResult(segment, targetField, result));
        }
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                if (lastModel == null || miningFunction.equals((Object)lastModel.getFunctionName())) break;
                throw new InvalidFeatureException(lastModel);
            }
        }
        return results;
    }

    private Evaluator createEvaluator(Model model) {
        ModelManager<? extends Model> modelManager = evaluatorFactory.getModelManager(this.getPmml(), model);
        return (Evaluator)modelManager;
    }

    private static class SegmentResult {
        private Segment segment = null;
        private FieldName targetField = null;
        private Map<FieldName, ?> result = null;

        public SegmentResult(Segment segment, FieldName targetField, Map<FieldName, ?> result) {
            this.setSegment(segment);
            this.setTargetField(targetField);
            this.setResult(result);
        }

        public Object getTargetValue() {
            return this.getResult().get(this.getTargetField());
        }

        public Segment getSegment() {
            return this.segment;
        }

        private void setSegment(Segment segment) {
            this.segment = segment;
        }

        public FieldName getTargetField() {
            return this.targetField;
        }

        private void setTargetField(FieldName targetField) {
            this.targetField = targetField;
        }

        public Map<FieldName, ?> getResult() {
            return this.result;
        }

        private void setResult(Map<FieldName, ?> result) {
            this.result = result;
        }
    }
}

