/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class PredicateUtil {
    private PredicateUtil() {
    }

    public static Boolean evaluate(Predicate predicate, EvaluationContext context) {
        if (predicate instanceof SimplePredicate) {
            return PredicateUtil.evaluateSimplePredicate((SimplePredicate)predicate, context);
        }
        if (predicate instanceof CompoundPredicate) {
            return PredicateUtil.evaluateCompoundPredicate((CompoundPredicate)predicate, context);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return PredicateUtil.evaluateSimpleSetPredicate((SimpleSetPredicate)predicate, context);
        }
        if (predicate instanceof True) {
            return PredicateUtil.evaluateTrue((True)predicate);
        }
        if (predicate instanceof False) {
            return PredicateUtil.evaluateFalse((False)predicate);
        }
        throw new UnsupportedFeatureException((PMMLObject)predicate);
    }

    public static Boolean evaluateSimplePredicate(SimplePredicate simplePredicate, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(simplePredicate.getField(), context);
        SimplePredicate.Operator operator = simplePredicate.getOperator();
        switch (operator) {
            case IS_MISSING: {
                return value == null;
            }
            case IS_NOT_MISSING: {
                return value != null;
            }
        }
        if (value == null) {
            return null;
        }
        switch (operator) {
            case EQUAL: {
                return value.equalsString(simplePredicate.getValue());
            }
            case NOT_EQUAL: {
                return !value.equalsString(simplePredicate.getValue());
            }
        }
        int order = value.compareToString(simplePredicate.getValue());
        switch (operator) {
            case LESS_THAN: {
                return order < 0;
            }
            case LESS_OR_EQUAL: {
                return order <= 0;
            }
            case GREATER_THAN: {
                return order > 0;
            }
            case GREATER_OR_EQUAL: {
                return order >= 0;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)simplePredicate, (Enum)operator);
    }

    public static Boolean evaluateCompoundPredicate(CompoundPredicate compoundPredicate, EvaluationContext context) {
        List predicates = compoundPredicate.getContent();
        if (predicates.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)compoundPredicate);
        }
        Boolean result = PredicateUtil.evaluate((Predicate)predicates.get(0), context);
        CompoundPredicate.BooleanOperator booleanOperator = compoundPredicate.getBooleanOperator();
        switch (booleanOperator) {
            case AND: 
            case OR: 
            case XOR: {
                break;
            }
            case SURROGATE: {
                if (result == null) break;
                return result;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)compoundPredicate, (Enum)booleanOperator);
            }
        }
        predicates = predicates.subList(1, predicates.size());
        block10: for (Predicate predicate : predicates) {
            Boolean value = PredicateUtil.evaluate(predicate, context);
            switch (booleanOperator) {
                case AND: {
                    result = PredicateUtil.binaryAnd(result, value);
                    continue block10;
                }
                case OR: {
                    result = PredicateUtil.binaryOr(result, value);
                    continue block10;
                }
                case XOR: {
                    result = PredicateUtil.binaryXor(result, value);
                    continue block10;
                }
                case SURROGATE: {
                    if (value == null) continue block10;
                    return value;
                }
            }
            throw new UnsupportedFeatureException((PMMLObject)compoundPredicate, (Enum)booleanOperator);
        }
        return result;
    }

    public static Boolean evaluateSimpleSetPredicate(SimpleSetPredicate simpleSetPredicate, EvaluationContext context) {
        FieldValue value = ExpressionUtil.evaluate(simpleSetPredicate.getField(), context);
        if (value == null) {
            throw new MissingFieldException(simpleSetPredicate.getField(), (PMMLObject)simpleSetPredicate);
        }
        Array array = simpleSetPredicate.getArray();
        List<String> content = ArrayUtil.getContent(array);
        SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.getBooleanOperator();
        switch (booleanOperator) {
            case IS_IN: {
                return value.equalsAnyString(content);
            }
            case IS_NOT_IN: {
                return !value.equalsAnyString(content);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)simpleSetPredicate, (Enum)booleanOperator);
    }

    public static Boolean evaluateTrue(True truePredicate) {
        return Boolean.TRUE;
    }

    public static Boolean evaluateFalse(False falsePredicate) {
        return Boolean.FALSE;
    }

    public static Boolean binaryAnd(Boolean left, Boolean right) {
        if (left == null) {
            if (right == null || right.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        if (right == null) {
            if (left == null || left.booleanValue()) {
                return null;
            }
            return Boolean.FALSE;
        }
        return left & right;
    }

    public static Boolean binaryOr(Boolean left, Boolean right) {
        if (left != null && left.booleanValue()) {
            return Boolean.TRUE;
        }
        if (right != null && right.booleanValue()) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return null;
        }
        return left | right;
    }

    public static Boolean binaryXor(Boolean left, Boolean right) {
        if (left == null || right == null) {
            return null;
        }
        return left ^ right;
    }
}

