/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import org.dmg.pmml.BayesInput;
import org.dmg.pmml.BayesOutput;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PairCounts;
import org.dmg.pmml.TargetValueCount;
import org.dmg.pmml.TargetValueCounts;
import org.dmg.pmml.TargetValueStat;
import org.dmg.pmml.TargetValueStats;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.NaiveBayesModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class NaiveBayesModelEvaluator
extends NaiveBayesModelManager
implements Evaluator {
    private List<BayesInput> bayesInputs = null;
    private Map<FieldName, Map<String, Double>> counts = null;

    public NaiveBayesModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public NaiveBayesModelEvaluator(PMML pmml, NaiveBayesModel naiveBayesModel) {
        super(pmml, naiveBayesModel);
    }

    public List<BayesInput> getBayesInputs() {
        if (this.bayesInputs == null) {
            this.bayesInputs = super.getBayesInputs();
        }
        return this.bayesInputs;
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        return ArgumentUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ? extends ClassificationMap> predictions;
        NaiveBayesModel naiveBayesModel = this.getModel();
        if (!naiveBayesModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)naiveBayesModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = naiveBayesModel.getFunctionName();
        switch (miningFunction) {
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)naiveBayesModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends ClassificationMap> evaluateClassification(ModelManagerEvaluationContext context) {
        NaiveBayesModel naiveBayesModel = this.getModel();
        ClassificationMap result = new ClassificationMap(ClassificationMap.Type.PROBABILITY);
        List<BayesInput> bayesInputs = this.getBayesInputs();
        for (BayesInput bayesInput : bayesInputs) {
            TargetValueCounts targetValueCounts;
            FieldName name = FieldName.create((String)bayesInput.getFieldName());
            FieldValue value = ExpressionUtil.evaluate(name, (EvaluationContext)context);
            if (value == null) continue;
            TargetValueStats targetValueStats = NaiveBayesModelEvaluator.getTargetValueStats(bayesInput);
            if (targetValueStats != null) {
                this.calculateContinuousProbabilities(value, targetValueStats, result);
                continue;
            }
            Map<String, Double> counts = this.getCounts(name);
            DerivedField derivedField = bayesInput.getDerivedField();
            if (derivedField != null) {
                Expression expression = derivedField.getExpression();
                if (!(expression instanceof Discretize)) {
                    throw new InvalidFeatureException((PMMLObject)derivedField);
                }
                Discretize discretize = (Discretize)expression;
                if ((value = DiscretizationUtil.discretize(discretize, value)) == null) {
                    throw new EvaluationException();
                }
                value = FieldValueUtil.refine((Field)derivedField, value);
            }
            if ((targetValueCounts = NaiveBayesModelEvaluator.getTargetValueCounts(bayesInput, value)) == null) continue;
            this.calculateDiscreteProbabilities(counts, targetValueCounts, naiveBayesModel.getThreshold(), result);
        }
        BayesOutput bayesOutput = this.getBayesOutput();
        this.calculatePriorProbabilities(bayesOutput.getTargetValueCounts(), result);
        Double max = (Double)Collections.max(result.values());
        Set entries = result.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue(Math.exp((Double)entry.getValue() - max));
        }
        result.normalizeValues();
        return TargetUtil.evaluateClassification(result, context);
    }

    private void calculateContinuousProbabilities(FieldValue value, TargetValueStats targetValueInfo, Map<String, Double> probabilities) {
        double x = value.asNumber().doubleValue();
        List targetValueStats = targetValueInfo.getTargetValueStats();
        for (TargetValueStat targetValueStat : targetValueStats) {
            String targetValue = targetValueStat.getValue();
            List content = targetValueStat.getContent();
            if (content.size() != 1) {
                throw new InvalidFeatureException((PMMLObject)targetValueStat);
            }
            ContinuousDistribution distribution = (ContinuousDistribution)content.get(0);
            if (!(distribution instanceof GaussianDistribution)) {
                throw new InvalidFeatureException((PMMLObject)targetValueStat);
            }
            GaussianDistribution gaussianDistribution = (GaussianDistribution)distribution;
            double mean = gaussianDistribution.getMean();
            double variance = gaussianDistribution.getVariance();
            double probability = Math.exp(-Math.pow(x - mean, 2.0) / (2.0 * variance)) / Math.sqrt(Math.PI * 2 * variance);
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(probability), probabilities);
        }
    }

    private void calculateDiscreteProbabilities(Map<String, Double> counts, TargetValueCounts targetValueInfo, double threshold, Map<String, Double> probabilities) {
        List targetValueCounts = targetValueInfo.getTargetValueCounts();
        for (TargetValueCount targetValueCount : targetValueCounts) {
            String targetValue = targetValueCount.getValue();
            Double count = counts.get(targetValue);
            double probability = targetValueCount.getCount() / count;
            if (VerificationUtil.isZero(probability, Precision.EPSILON)) {
                probability = threshold;
            }
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(probability), probabilities);
        }
    }

    private void calculatePriorProbabilities(TargetValueCounts targetValueInfo, Map<String, Double> probabilities) {
        List targetValueCounts = targetValueInfo.getTargetValueCounts();
        for (TargetValueCount targetValueCount : targetValueCounts) {
            String targetValue = targetValueCount.getValue();
            NaiveBayesModelEvaluator.updateSum(targetValue, Math.log(targetValueCount.getCount()), probabilities);
        }
    }

    public Map<String, Double> getCounts(FieldName name) {
        Map<FieldName, Map<String, Double>> counts = this.getCounts();
        return counts.get(name);
    }

    private Map<FieldName, Map<String, Double>> getCounts() {
        if (this.counts == null) {
            this.counts = this.parseCounts();
        }
        return this.counts;
    }

    private Map<FieldName, Map<String, Double>> parseCounts() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        List<BayesInput> bayesInputs = this.getBayesInputs();
        for (BayesInput bayesInput : bayesInputs) {
            FieldName name = new FieldName(bayesInput.getFieldName());
            LinkedHashMap counts = Maps.newLinkedHashMap();
            List pairCounts = bayesInput.getPairCounts();
            for (PairCounts pairCount : pairCounts) {
                List targetValueCounts = pairCount.getTargetValueCounts().getTargetValueCounts();
                for (TargetValueCount targetValueCount : targetValueCounts) {
                    NaiveBayesModelEvaluator.updateSum(targetValueCount.getValue(), targetValueCount.getCount(), counts);
                }
            }
            result.put(name, counts);
        }
        return result;
    }

    private static void updateSum(String key, Double value, Map<String, Double> counts) {
        Double count = counts.get(key);
        if (count == null) {
            count = 0.0;
        }
        counts.put(key, count + value);
    }

    private static TargetValueStats getTargetValueStats(BayesInput bayesInput) {
        return bayesInput.getTargetValueStats();
    }

    private static TargetValueCounts getTargetValueCounts(BayesInput bayesInput, FieldValue value) {
        List pairCounts = bayesInput.getPairCounts();
        for (PairCounts pairCount : pairCounts) {
            if (!value.equalsString(pairCount.getValue())) continue;
            return pairCount.getTargetValueCounts();
        }
        return null;
    }
}

