/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentUtilTest {
    @Test
    public void prepare() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        List fieldValues = dataField.getValues();
        List fieldIntervals = dataField.getIntervals();
        MiningField miningField = new MiningField(name);
        miningField.setLowValue(Double.valueOf(1.0));
        miningField.setHighValue(Double.valueOf(3.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "1"));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Value missingValue = ArgumentUtilTest.createValue("N/A", Value.Property.MISSING);
        fieldValues.add(missingValue);
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        fieldValues.clear();
        fieldIntervals.clear();
        fieldValues.add(missingValue);
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED);
        validInterval.setLeftMargin(Double.valueOf(1.0));
        validInterval.setRightMargin(Double.valueOf(3.0));
        fieldIntervals.add(validInterval);
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)-1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_EXTREME_VALUES);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)3.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        fieldValues.clear();
        fieldIntervals.clear();
        ArrayList validValues = Lists.newArrayList();
        validValues.add(ArgumentUtilTest.createValue("1", Value.Property.VALID));
        validValues.add(ArgumentUtilTest.createValue("2", Value.Property.VALID));
        validValues.add(ArgumentUtilTest.createValue("3", Value.Property.VALID));
        fieldValues.add(missingValue);
        fieldValues.addAll(validValues);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        fieldValues.clear();
        fieldIntervals.clear();
        ArrayList invalidValues = Lists.newArrayList();
        invalidValues.add(ArgumentUtilTest.createValue("1", Value.Property.INVALID));
        fieldValues.add(missingValue);
        fieldValues.addAll(invalidValues);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
    }

    @Test
    public void isInvalid() {
        Assert.assertFalse((boolean)ArgumentUtil.isInvalid(null, null));
    }

    @Test
    public void isValid() {
        Assert.assertFalse((boolean)ArgumentUtil.isValid(null, null));
    }

    private static Object prepare(DataField dataField, MiningField miningField, Object value) {
        FieldValue result = ArgumentUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)value);
        return FieldValueUtil.getValue((FieldValue)result);
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value);
        result.setProperty(property);
        return result;
    }
}

