/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Coefficient;
import org.dmg.pmml.Coefficients;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.KernelType;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.SupportVector;
import org.dmg.pmml.SupportVectorMachine;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.SupportVectors;
import org.dmg.pmml.SvmClassificationMethodType;
import org.dmg.pmml.SvmRepresentationType;
import org.dmg.pmml.VectorDictionary;
import org.dmg.pmml.VectorFields;
import org.dmg.pmml.VectorInstance;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.KernelTypeUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLObjectUtil;
import org.jpmml.evaluator.SparseArrayUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class SupportVectorMachineModelEvaluator
extends ModelEvaluator<SupportVectorMachineModel> {
    private static final LoadingCache<SupportVectorMachineModel, Map<String, double[]>> vectorCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SupportVectorMachineModel, Map<String, double[]>>(){

        public Map<String, double[]> load(SupportVectorMachineModel supportVectorMachineModel) {
            return SupportVectorMachineModelEvaluator.parseVectorDictionary(supportVectorMachineModel);
        }
    });

    public SupportVectorMachineModelEvaluator(PMML pmml) {
        this(pmml, (SupportVectorMachineModel)SupportVectorMachineModelEvaluator.find((List)pmml.getModels(), SupportVectorMachineModel.class));
    }

    public SupportVectorMachineModelEvaluator(PMML pmml, SupportVectorMachineModel supportVectorMachineModel) {
        super(pmml, supportVectorMachineModel);
    }

    public String getSummary() {
        return "Support vector machine";
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, Serializable> predictions;
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        if (!supportVectorMachineModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)supportVectorMachineModel);
        }
        SvmRepresentationType svmRepresentation = supportVectorMachineModel.getSvmRepresentation();
        switch (svmRepresentation) {
            case SUPPORT_VECTORS: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum)svmRepresentation);
            }
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = supportVectorMachineModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends Number> evaluateRegression(ModelManagerEvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        if (supportVectorMachines.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)supportVectorMachineModel);
        }
        SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
        double[] input = this.createInput(context);
        Double value = this.evaluateSupportVectorMachine(supportVectorMachine, input);
        return TargetUtil.evaluateRegression(value, context);
    }

    private Map<FieldName, ? extends ClassificationMap> evaluateClassification(ModelManagerEvaluationContext context) {
        ClassificationMap result;
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        if (supportVectorMachines.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)supportVectorMachineModel);
        }
        SvmClassificationMethodType svmClassificationMethod = this.getClassificationMethod();
        switch (svmClassificationMethod) {
            case ONE_AGAINST_ALL: {
                result = new ClassificationMap(ClassificationMap.Type.DISTANCE);
                break;
            }
            case ONE_AGAINST_ONE: {
                result = new ClassificationMap(ClassificationMap.Type.VOTE);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)supportVectorMachineModel, (Enum)svmClassificationMethod);
            }
        }
        double[] input = this.createInput(context);
        for (SupportVectorMachine supportVectorMachine : supportVectorMachines) {
            String category = supportVectorMachine.getTargetCategory();
            String alternateCategory = supportVectorMachine.getAlternateTargetCategory();
            Double value = this.evaluateSupportVectorMachine(supportVectorMachine, input);
            switch (svmClassificationMethod) {
                case ONE_AGAINST_ALL: {
                    if (category == null || alternateCategory != null) {
                        throw new InvalidFeatureException((PMMLObject)supportVectorMachine);
                    }
                    result.put(category, value);
                    break;
                }
                case ONE_AGAINST_ONE: {
                    String label;
                    Double vote;
                    if (category == null || alternateCategory == null) {
                        throw new InvalidFeatureException((PMMLObject)supportVectorMachine);
                    }
                    Double threshold = supportVectorMachine.getThreshold();
                    if (threshold == null) {
                        threshold = supportVectorMachineModel.getThreshold();
                    }
                    if ((vote = (Double)result.get(label = value.compareTo(threshold) < 0 ? category : alternateCategory)) == null) {
                        vote = 0.0;
                    }
                    result.put(label, vote + 1.0);
                    break;
                }
            }
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Double evaluateSupportVectorMachine(SupportVectorMachine supportVectorMachine, double[] input) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        double result = 0.0;
        KernelType kernelType = supportVectorMachineModel.getKernelType();
        Coefficients coefficients = supportVectorMachine.getCoefficients();
        Iterator coefficientIterator = coefficients.iterator();
        SupportVectors supportVectors = supportVectorMachine.getSupportVectors();
        Iterator supportVectorIterator = supportVectors.iterator();
        Map<String, double[]> vectorMap = this.getVectorMap();
        while (coefficientIterator.hasNext() && supportVectorIterator.hasNext()) {
            Coefficient coefficient = (Coefficient)coefficientIterator.next();
            SupportVector supportVector = (SupportVector)supportVectorIterator.next();
            double[] vector = vectorMap.get(supportVector.getVectorId());
            if (vector == null) {
                throw new InvalidFeatureException((PMMLObject)supportVector);
            }
            Double value = KernelTypeUtil.evaluate(kernelType, input, vector);
            result += coefficient.getValue() * value;
        }
        if (coefficientIterator.hasNext() || supportVectorIterator.hasNext()) {
            throw new InvalidFeatureException((PMMLObject)supportVectorMachine);
        }
        return result += coefficients.getAbsoluteValue();
    }

    private SvmClassificationMethodType getClassificationMethod() {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        SvmClassificationMethodType svmClassificationMethod = (SvmClassificationMethodType)PMMLObjectUtil.getField((PMMLObject)supportVectorMachineModel, "classificationMethod");
        if (svmClassificationMethod != null) {
            return svmClassificationMethod;
        }
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        Iterator i$ = supportVectorMachines.iterator();
        if (i$.hasNext()) {
            SupportVectorMachine supportVectorMachine = (SupportVectorMachine)i$.next();
            String category = supportVectorMachine.getTargetCategory();
            String alternateCategory = supportVectorMachine.getAlternateTargetCategory();
            if (category != null) {
                if (alternateCategory != null) {
                    return SvmClassificationMethodType.ONE_AGAINST_ONE;
                }
                return SvmClassificationMethodType.ONE_AGAINST_ALL;
            }
            throw new InvalidFeatureException((PMMLObject)supportVectorMachine);
        }
        throw new InvalidFeatureException((PMMLObject)supportVectorMachineModel);
    }

    private double[] createInput(EvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        VectorDictionary vectorDictionary = supportVectorMachineModel.getVectorDictionary();
        VectorFields vectorFields = vectorDictionary.getVectorFields();
        List fieldRefs = vectorFields.getFieldRefs();
        double[] result = new double[fieldRefs.size()];
        for (int i = 0; i < fieldRefs.size(); ++i) {
            FieldRef fieldRef = (FieldRef)fieldRefs.get(i);
            FieldValue value = ExpressionUtil.evaluate((Expression)fieldRef, context);
            if (value == null) {
                throw new MissingFieldException(fieldRef.getField(), (PMMLObject)vectorFields);
            }
            result[i] = value.asNumber().doubleValue();
        }
        Integer numberOfFields = vectorFields.getNumberOfFields();
        if (numberOfFields != null && numberOfFields != result.length) {
            throw new InvalidFeatureException((PMMLObject)vectorFields);
        }
        return result;
    }

    private Map<String, double[]> getVectorMap() {
        return this.getValue(vectorCache);
    }

    private static Map<String, double[]> parseVectorDictionary(SupportVectorMachineModel supportVectorMachineModel) {
        VectorDictionary vectorDictionary = supportVectorMachineModel.getVectorDictionary();
        VectorFields vectorFields = vectorDictionary.getVectorFields();
        LinkedHashMap result = Maps.newLinkedHashMap();
        List vectorInstances = vectorDictionary.getVectorInstances();
        for (VectorInstance vectorInstance : vectorInstances) {
            double[] vector;
            Array array = vectorInstance.getArray();
            RealSparseArray sparseArray = vectorInstance.getREALSparseArray();
            if (array != null && sparseArray == null) {
                vector = ArrayUtil.toArray(array);
            } else if (array == null && sparseArray != null) {
                vector = SparseArrayUtil.toArray(sparseArray);
            } else {
                throw new InvalidFeatureException((PMMLObject)vectorInstance);
            }
            Integer numberOfFields = vectorFields.getNumberOfFields();
            if (numberOfFields != null && numberOfFields != vector.length) {
                throw new InvalidFeatureException((PMMLObject)vectorInstance);
            }
            result.put(vectorInstance.getId(), vector);
        }
        Integer numberOfVectors = vectorDictionary.getNumberOfVectors();
        if (numberOfVectors != null && numberOfVectors.intValue() != result.size()) {
            throw new InvalidFeatureException((PMMLObject)vectorDictionary);
        }
        return result;
    }
}

