/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.ArrayType;
import org.jpmml.evaluator.ArrayUtil;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtilTest {
    @Test
    public void tokenizeIntArray() {
        Assert.assertEquals(Arrays.asList("1", "2", "3"), ArrayUtilTest.tokenizeIntArray("1 2 3"));
    }

    @Test
    public void tokenizeStringArray() {
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.tokenizeStringArray("a b c"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), ArrayUtilTest.tokenizeStringArray("\"a\" \"b\" \"c\""));
        Assert.assertEquals(Arrays.asList("a b c"), ArrayUtilTest.tokenizeStringArray("\"a b c\""));
        Assert.assertEquals(Arrays.asList("\"a b c"), ArrayUtilTest.tokenizeStringArray("\"a b c"));
        Assert.assertEquals(Arrays.asList("\\a", "\\b\\", "c\\"), ArrayUtilTest.tokenizeStringArray("\\a \\b\\ c\\"));
        Assert.assertEquals(Arrays.asList("a \"b\" c"), ArrayUtilTest.tokenizeStringArray("\"a \\\"b\\\" c\""));
        Assert.assertEquals(Arrays.asList("\"a b c\""), ArrayUtilTest.tokenizeStringArray("\"\\\"a b c\\\"\""));
    }

    private static List<String> tokenizeIntArray(String content) {
        return ArrayUtil.tokenize((ArrayType)new ArrayType(content, ArrayType.Type.INT));
    }

    private static List<String> tokenizeStringArray(String content) {
        return ArrayUtil.tokenize((ArrayType)new ArrayType(content, ArrayType.Type.STRING));
    }
}

