/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.Batch;
import org.jpmml.evaluator.CsvUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.PmmlUtil;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.manager.ModelManagerFactory;
import org.jpmml.manager.PMMLManager;

public class BatchUtil {
    private static final double precision = 1.0E-6;

    private BatchUtil() {
    }

    public static boolean evaluate(Batch batch) throws Exception {
        List<Map<FieldName, String>> input = CsvUtil.load(batch.getInput());
        List<Map<FieldName, String>> output = CsvUtil.load(batch.getOutput());
        if (input.size() != output.size()) {
            throw new RuntimeException();
        }
        PMML pmml = PmmlUtil.load(batch.getModel());
        PMMLManager pmmlManager = new PMMLManager(pmml);
        Evaluator evaluator = (Evaluator)pmmlManager.getModelManager(null, (ModelManagerFactory)ModelEvaluatorFactory.getInstance());
        List activeFields = evaluator.getActiveFields();
        List predictedFields = evaluator.getPredictedFields();
        boolean success = true;
        for (int i = 0; i < input.size(); ++i) {
            Map<FieldName, String> inputRow = input.get(i);
            Map<FieldName, String> outputRow = output.get(i);
            LinkedHashMap<FieldName, Object> parameters = new LinkedHashMap<FieldName, Object>();
            for (FieldName activeField : activeFields) {
                String inputCell = inputRow.get(activeField);
                parameters.put(activeField, evaluator.prepare(activeField, (Object)inputCell));
            }
            Map result = evaluator.evaluate(parameters);
            for (FieldName predictedField : predictedFields) {
                String outputCell = outputRow.get(predictedField);
                Object predictedValue = EvaluatorUtil.decode(result.get(predictedField));
                DataType dataType = ParameterUtil.getDataType((Object)predictedValue);
                switch (dataType) {
                    case INTEGER: 
                    case FLOAT: 
                    case DOUBLE: {
                        dataType = DataType.DOUBLE;
                        break;
                    }
                }
                success &= VerificationUtil.acceptable((Object)ParameterUtil.parse((DataType)dataType, (String)outputCell), (Object)predictedValue, (double)1.0E-6);
            }
        }
        return success;
    }
}

