/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NearestNeighborModel;
import org.jpmml.evaluator.InstanceClassificationMap;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.NearestNeighborModelEvaluator;
import org.jpmml.evaluator.NearestNeighborModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class ClusteringNeighborhoodTest
extends NearestNeighborModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        NearestNeighborModelEvaluator evaluator = this.createEvaluator();
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)evaluator.getModel();
        FieldName maritialStatus = new FieldName("maritial status");
        FieldName age = new FieldName("age");
        FieldName dependents = new FieldName("dependents");
        LinkedHashMap arguments = Maps.newLinkedHashMap();
        arguments.put(maritialStatus, "m");
        arguments.put(age, 40.0);
        arguments.put(dependents, 2);
        Map result = evaluator.evaluate((Map)arguments);
        InstanceClassificationMap target = (InstanceClassificationMap)result.get(evaluator.getTargetField());
        try {
            target.getResult();
            Assert.fail();
        }
        catch (MissingResultException mre) {
            // empty catch block
        }
        Assert.assertEquals(Arrays.asList("4", "3", "2"), target.getEntityIdRanking().subList(0, 3));
        Assert.assertEquals((Object)"4", result.get(new FieldName("neighbor1")));
        Assert.assertEquals((Object)"3", result.get(new FieldName("neighbor2")));
        Assert.assertEquals((Object)"2", result.get(new FieldName("neighbor3")));
    }
}

