/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NearestNeighborModel;
import org.jpmml.evaluator.InstanceClassificationMap;
import org.jpmml.evaluator.NearestNeighborModelEvaluator;
import org.jpmml.evaluator.NearestNeighborModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class MixedNeighborhoodTest
extends NearestNeighborModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        NearestNeighborModelEvaluator evaluator = this.createEvaluator();
        NearestNeighborModel nearestNeighborModel = (NearestNeighborModel)evaluator.getModel();
        nearestNeighborModel.setNumberOfNeighbors(Integer.valueOf(1));
        FieldName petalLength = new FieldName("petal length");
        FieldName petalWidth = new FieldName("petal width");
        FieldName sepalLength = new FieldName("sepal length");
        FieldName sepalWidth = new FieldName("sepal width");
        LinkedHashMap arguments = Maps.newLinkedHashMap();
        arguments.put(petalLength, 4.7);
        arguments.put(petalWidth, 1.4);
        arguments.put(sepalLength, 7.0);
        arguments.put(sepalWidth, 3.2);
        Map result = evaluator.evaluate((Map)arguments);
        InstanceClassificationMap species = (InstanceClassificationMap)result.get(new FieldName("species"));
        Assert.assertEquals((Object)20.0, (Object)species.getResult());
        Assert.assertEquals((Object)"51", species.getEntityIdRanking().get(0));
        InstanceClassificationMap speciesClass = (InstanceClassificationMap)result.get(new FieldName("species_class"));
        Assert.assertEquals((Object)"Iris-versicolor", (Object)speciesClass.getResult());
        Assert.assertEquals((Object)"51", speciesClass.getEntityIdRanking().get(0));
        Assert.assertEquals((Object)20.0, result.get(new FieldName("output_1")));
        Assert.assertEquals((Object)"Iris-versicolor", result.get(new FieldName("output_2")));
    }
}

