/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Entity;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.HasEntityId;

abstract class EntityClassificationMap<E extends Entity>
extends ClassificationMap<String>
implements HasEntityId {
    private E entity = null;
    private Double maxValue = null;

    EntityClassificationMap(ClassificationMap.Type type) {
        super(type);
    }

    EntityClassificationMap(ClassificationMap.Type type, E entity) {
        super(type);
        this.setEntity(entity);
    }

    @Override
    public String getResult() {
        return (String)super.getResult();
    }

    @Override
    public String getEntityId() {
        E entity = this.getEntity();
        if (entity != null) {
            return entity.getId();
        }
        return null;
    }

    Double put(E entity, String key, Double value) {
        ClassificationMap.Type type = this.getType();
        if (this.maxValue == null || type.isMoreOptimal(value, this.maxValue)) {
            this.maxValue = value;
            this.setEntity(entity);
        }
        return super.put(key, value);
    }

    public E getEntity() {
        return this.entity;
    }

    void setEntity(E entity) {
        this.entity = entity;
    }
}

