/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Map;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasClusterAffinity;
import org.jpmml.evaluator.HasClusterId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.MissingResultException;

class InstanceClassificationMap
extends ClassificationMap<String>
implements HasEntityIdRanking,
HasClusterId,
HasAffinityRanking,
HasClusterAffinity {
    private Object result = null;

    InstanceClassificationMap(Object result) {
        super(ClassificationMap.Type.DISTANCE);
        this.setResult(result);
    }

    @Override
    public Object getResult() {
        if (this.result == null) {
            throw new MissingResultException(null);
        }
        return this.result;
    }

    private void setResult(Object result) {
        this.result = result;
    }

    @Override
    public String getEntityId() {
        Map.Entry entry = this.getWinner();
        if (entry == null) {
            return null;
        }
        return (String)entry.getKey();
    }

    @Override
    public List<String> getEntityIdRanking() {
        return this.getWinnerKeys();
    }

    @Override
    public String getClusterId() {
        return this.getEntityId();
    }

    @Override
    public Double getAffinity(String id) {
        ClassificationMap.Type type = this.getType();
        if (!ClassificationMap.Type.DISTANCE.equals((Object)type)) {
            throw new EvaluationException();
        }
        return this.getFeature(id);
    }

    @Override
    public List<Double> getAffinityRanking() {
        ClassificationMap.Type type = this.getType();
        if (!ClassificationMap.Type.DISTANCE.equals((Object)type)) {
            throw new EvaluationException();
        }
        return this.getWinnerValues();
    }

    @Override
    public Double getClusterAffinity() {
        return this.getAffinity(this.getClusterId());
    }
}

