/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.BinarySimilarity;
import org.dmg.pmml.Chebychev;
import org.dmg.pmml.CityBlock;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.ComparisonField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Jaccard;
import org.dmg.pmml.Measure;
import org.dmg.pmml.Minkowski;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.SimpleMatching;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.Tanimoto;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class MeasureUtil {
    private MeasureUtil() {
    }

    public static boolean isDistance(Measure measure) {
        return measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof Chebychev || measure instanceof CityBlock || measure instanceof Minkowski;
    }

    public static Double evaluateDistance(ComparisonMeasure comparisonMeasure, List<? extends ComparisonField> comparisonFields, List<FieldValue> values, List<FieldValue> referenceValues, Double adjustment) {
        double innerPower;
        double outerPower;
        Measure measure = comparisonMeasure.getMeasure();
        if (measure instanceof Euclidean) {
            outerPower = 2.0;
            innerPower = 2.0;
        } else if (measure instanceof SquaredEuclidean) {
            innerPower = 2.0;
            outerPower = 1.0;
        } else if (measure instanceof Chebychev || measure instanceof CityBlock) {
            outerPower = 1.0;
            innerPower = 1.0;
        } else if (measure instanceof Minkowski) {
            Minkowski minkowski = (Minkowski)measure;
            double p = minkowski.getPParameter();
            if (p < 0.0) {
                throw new InvalidFeatureException((PMMLObject)minkowski);
            }
            innerPower = outerPower = p;
        } else {
            throw new UnsupportedFeatureException((PMMLObject)measure);
        }
        ArrayList distances = Lists.newArrayList();
        for (int i = 0; i < comparisonFields.size(); ++i) {
            ComparisonField comparisonField = comparisonFields.get(i);
            FieldValue value = values.get(i);
            if (value == null) continue;
            FieldValue referenceValue = referenceValues.get(i);
            Double distance = MeasureUtil.evaluateInnerFunction(comparisonMeasure, comparisonField, value, referenceValue, innerPower);
            distances.add(distance);
        }
        if (measure instanceof Euclidean || measure instanceof SquaredEuclidean || measure instanceof CityBlock || measure instanceof Minkowski) {
            double sum = 0.0;
            for (Double distance : distances) {
                sum += distance.doubleValue();
            }
            return Math.pow(sum * adjustment, 1.0 / outerPower);
        }
        if (measure instanceof Chebychev) {
            Double max = (Double)Collections.max(distances);
            return max * adjustment;
        }
        throw new UnsupportedFeatureException((PMMLObject)measure);
    }

    public static boolean isSimilarity(Measure measure) {
        return measure instanceof SimpleMatching || measure instanceof Jaccard || measure instanceof Tanimoto || measure instanceof BinarySimilarity;
    }

    private static double evaluateInnerFunction(ComparisonMeasure comparisonMeasure, ComparisonField comparisonField, FieldValue value, FieldValue referenceValue, Double power) {
        double distance;
        CompareFunctionType compareFunction = comparisonField.getCompareFunction();
        if (compareFunction == null) {
            compareFunction = comparisonMeasure.getCompareFunction();
            switch (compareFunction) {
                case ABS_DIFF: 
                case DELTA: 
                case EQUAL: {
                    break;
                }
                case GAUSS_SIM: 
                case TABLE: {
                    throw new InvalidFeatureException((PMMLObject)comparisonMeasure);
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)comparisonMeasure, (Enum)compareFunction);
                }
            }
        }
        switch (compareFunction) {
            case ABS_DIFF: {
                double z = MeasureUtil.difference(value, referenceValue);
                distance = Math.abs(z);
                break;
            }
            case GAUSS_SIM: {
                Double similarityScale = comparisonField.getSimilarityScale();
                if (similarityScale == null) {
                    throw new InvalidFeatureException((PMMLObject)comparisonField);
                }
                double z = MeasureUtil.difference(value, referenceValue);
                double s = similarityScale;
                distance = Math.exp(-Math.log(2.0) * Math.pow(z, 2.0) / Math.pow(s, 2.0));
                break;
            }
            case DELTA: {
                boolean equals = MeasureUtil.equals(value, referenceValue);
                distance = equals ? 0.0 : 1.0;
            }
            case EQUAL: {
                boolean equals = MeasureUtil.equals(value, referenceValue);
                distance = equals ? 1.0 : 0.0;
                break;
            }
            case TABLE: {
                throw new UnsupportedFeatureException((PMMLObject)comparisonField, (Enum)compareFunction);
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)comparisonField, (Enum)compareFunction);
            }
        }
        return comparisonField.getFieldWeight() * Math.pow(distance, power);
    }

    private static double difference(FieldValue x, FieldValue y) {
        return x.asNumber().doubleValue() - y.asNumber().doubleValue();
    }

    private static boolean equals(FieldValue x, FieldValue y) {
        return x.equalsValue(y);
    }

    public static Double calculateAdjustment(List<FieldValue> values, List<Double> adjustmentValues) {
        double sum = 0.0;
        double nonmissingSum = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            Double adjustmentValue = adjustmentValues.get(i);
            sum += adjustmentValue.doubleValue();
            nonmissingSum += value != null ? adjustmentValue : 0.0;
        }
        return sum / nonmissingSum;
    }

    public static Double calculateAdjustment(List<FieldValue> values) {
        double sum = 0.0;
        double nonmissingSum = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            FieldValue value = values.get(i);
            sum += 1.0;
            nonmissingSum += value != null ? 1.0 : 0.0;
        }
        return sum / nonmissingSum;
    }
}

