/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.CategoricalPredictor;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.NumericPredictor;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PredictorTerm;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionNormalizationMethodType;
import org.dmg.pmml.RegressionTable;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingResultException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class RegressionModelEvaluator
extends ModelEvaluator<RegressionModel> {
    public RegressionModelEvaluator(PMML pmml) {
        this(pmml, (RegressionModel)RegressionModelEvaluator.find((List)pmml.getModels(), RegressionModel.class));
    }

    public RegressionModelEvaluator(PMML pmml, RegressionModel regressionModel) {
        super(pmml, regressionModel);
    }

    public String getSummary() {
        return "Regression";
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, Serializable> predictions;
        RegressionModel regressionModel = (RegressionModel)this.getModel();
        if (!regressionModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)regressionModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext(this);
        context.pushFrame(arguments);
        MiningFunctionType miningFunction = regressionModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)regressionModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends Number> evaluateRegression(ModelManagerEvaluationContext context) {
        RegressionModel regressionModel = (RegressionModel)this.getModel();
        List regressionTables = regressionModel.getRegressionTables();
        if (regressionTables.size() != 1) {
            throw new InvalidFeatureException((PMMLObject)regressionModel);
        }
        RegressionTable regressionTable = (RegressionTable)regressionTables.get(0);
        Double value = RegressionModelEvaluator.evaluateRegressionTable(regressionTable, context);
        if (value != null) {
            value = RegressionModelEvaluator.normalizeRegressionResult(regressionModel, value);
        }
        return TargetUtil.evaluateRegression(value, context);
    }

    private Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(ModelManagerEvaluationContext context) {
        RegressionModel regressionModel = (RegressionModel)this.getModel();
        List regressionTables = regressionModel.getRegressionTables();
        if (regressionTables.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)regressionModel);
        }
        ClassificationMap<String> result = new ClassificationMap<String>(ClassificationMap.Type.PROBABILITY);
        double sumExp = 0.0;
        for (RegressionTable regressionTable : regressionTables) {
            String category = regressionTable.getTargetCategory();
            if (category == null) {
                throw new InvalidFeatureException((PMMLObject)regressionTable);
            }
            Double value = RegressionModelEvaluator.evaluateRegressionTable(regressionTable, context);
            if (value == null) {
                throw new MissingResultException((PMMLObject)regressionTable);
            }
            sumExp += Math.exp(value);
            result.put(category, value);
        }
        FieldName targetField = this.getTargetField();
        DataField dataField = this.getDataField(targetField);
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CATEGORICAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
            }
        }
        Set entries = result.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue(RegressionModelEvaluator.normalizeClassificationResult(regressionModel, (Double)entry.getValue(), sumExp));
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private static Double evaluateRegressionTable(RegressionTable regressionTable, EvaluationContext context) {
        double result = 0.0;
        result += regressionTable.getIntercept();
        List numericPredictors = regressionTable.getNumericPredictors();
        for (NumericPredictor numericPredictor : numericPredictors) {
            FieldName name = numericPredictor.getName();
            FieldValue value = ExpressionUtil.evaluate(name, context);
            if (value == null) {
                context.addWarning("Missing argument \"" + name.getValue() + "\"");
                return null;
            }
            result += numericPredictor.getCoefficient() * Math.pow(value.asNumber().doubleValue(), numericPredictor.getExponent());
        }
        List categoricalPredictors = regressionTable.getCategoricalPredictors();
        for (CategoricalPredictor categoricalPredictor : categoricalPredictors) {
            FieldName name = categoricalPredictor.getName();
            FieldValue value = ExpressionUtil.evaluate(name, context);
            if (value == null) {
                context.addWarning("Missing argument \"" + name.getValue() + "\"");
                continue;
            }
            boolean equals = value.equalsString(categoricalPredictor.getValue());
            result += categoricalPredictor.getCoefficient() * (equals ? 1.0 : 0.0);
        }
        List predictorTerms = regressionTable.getPredictorTerms();
        for (PredictorTerm predictorTerm : predictorTerms) {
            double product = predictorTerm.getCoefficient();
            List fieldRefs = predictorTerm.getFieldRefs();
            if (fieldRefs.size() < 1) {
                throw new InvalidFeatureException((PMMLObject)predictorTerm);
            }
            for (FieldRef fieldRef : fieldRefs) {
                FieldValue value = ExpressionUtil.evaluateFieldRef(fieldRef, context);
                if (value == null) {
                    return null;
                }
                product *= ((Number)((Object)value)).doubleValue();
            }
            result += product;
        }
        return result;
    }

    private static Double normalizeRegressionResult(RegressionModel regressionModel, Double value) {
        RegressionNormalizationMethodType regressionNormalizationMethod = regressionModel.getNormalizationMethod();
        switch (regressionNormalizationMethod) {
            case NONE: {
                return value;
            }
            case SOFTMAX: 
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-value.doubleValue()));
            }
            case EXP: {
                return Math.exp(value);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)regressionModel, (Enum)regressionNormalizationMethod);
    }

    private static Double normalizeClassificationResult(RegressionModel regressionModel, Double value, Double sumExp) {
        RegressionNormalizationMethodType regressionNormalizationMethod = regressionModel.getNormalizationMethod();
        switch (regressionNormalizationMethod) {
            case NONE: {
                return value;
            }
            case SOFTMAX: {
                return Math.exp(value) / sumExp;
            }
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-value.doubleValue()));
            }
            case CLOGLOG: {
                return 1.0 - Math.exp(-Math.exp(value));
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-value.doubleValue()));
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)regressionModel, (Enum)regressionNormalizationMethod);
    }
}

