/*
 * Copyright (c) 2013 University of Tartu
 */
package org.jpmml.evaluator;

import java.util.*;

import org.dmg.pmml.*;

import com.google.common.collect.*;

public class EvaluatorUtil {

	private EvaluatorUtil(){
	}

	/**
	 * @see Computable
	 */
	static
	public Object decode(Object object){

		if(object instanceof Computable){
			Computable computable = (Computable)object;

			return computable.getResult();
		}

		return object;
	}

	/**
	 * Decouples a {@link Map} instance from the current runtime environment by decoding both its keys and values.
	 */
	static
	public Map<String, ?> decode(Map<FieldName, ?> map){
		Map<String, Object> result = Maps.newLinkedHashMap();

		Collection<? extends Map.Entry<FieldName, ?>> entries = map.entrySet();
		for(Map.Entry<FieldName, ?> entry : entries){
			FieldName key = entry.getKey();
			Object value = entry.getValue();

			if(key == null){
				continue;
			}

			result.put(key.getValue(), decode(value));
		}

		return result;
	}

	static
	public FieldValue prepare(Evaluator evaluator, FieldName name, Object value){

		if(value instanceof Collection){
			Collection<?> rawValues = (Collection<?>)value;

			// Try to preserve the original Collection contract
			Collection<Object> preparedValues = (rawValues instanceof Set ? Sets.newLinkedHashSet() : Lists.newArrayList());

			DataType dataType = null;

			OpType opType = null;

			for(Object rawValue : rawValues){
				FieldValue preparedValue = evaluator.prepare(name, rawValue);
				if(preparedValue != null){

					if(dataType == null){
						dataType = preparedValue.getDataType();
					} // End if

					if(opType == null){
						opType = preparedValue.getOpType();
					}
				}

				preparedValues.add(FieldValueUtil.getValue(preparedValue));
			}

			return FieldValueUtil.create(dataType, opType, preparedValues);
		}

		return evaluator.prepare(name, value);
	}

	static
	public <K> List<Map<K, Object>> groupRows(K groupKey, List<Map<K, Object>> table){
		Map<Object, ListMultimap<K, Object>> groupedRows = Maps.newLinkedHashMap();

		for(int i = 0; i < table.size(); i++){
			Map<K, ?> row = table.get(i);

			Object groupValue = row.get(groupKey);

			ListMultimap<K, Object> groupedRow = groupedRows.get(groupValue);
			if(groupedRow == null){
				groupedRow = ArrayListMultimap.create();

				groupedRows.put(groupValue, groupedRow);
			}

			Collection<? extends Map.Entry<K, ?>> entries = row.entrySet();
			for(Map.Entry<K, ?> entry : entries){
				K key = entry.getKey();
				Object value = entry.getValue();

				groupedRow.put(key, value);
			}
		}

		List<Map<K, Object>> resultTable = Lists.newArrayList();

		Collection<Map.Entry<Object, ListMultimap<K, Object>>> entries = groupedRows.entrySet();
		for(Map.Entry<Object, ListMultimap<K, Object>> entry : entries){
			Map<K, Object> resultRow = Maps.newLinkedHashMap();
			resultRow.putAll((entry.getValue()).asMap());

			// The value of the "group by" column is a single Object, not a Collection (ie. java.util.List) of Objects
			resultRow.put(groupKey, entry.getKey());

			resultTable.add(resultRow);
		}

		return resultTable;
	}
}