/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.AssociationModelEvaluator;
import org.jpmml.evaluator.AssociationModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class AssociationAlgorithmTest
extends AssociationModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        this.evaluate(Arrays.asList("Cracker", "Coke"), Arrays.asList("1", "3"), Arrays.asList("1"), Arrays.asList("3"));
        this.evaluate(Arrays.asList("Cracker", "Water"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("3", "4", "5"), Arrays.asList("1", "2"));
        this.evaluate(Arrays.asList("Water", "Coke"), Arrays.asList("2", "5"), Arrays.asList("2", "5"), Arrays.asList(new String[0]));
        this.evaluate(Arrays.asList("Cracker", "Water", "Coke"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("4", "5"), Arrays.asList("1", "2", "3"));
        this.evaluate(Arrays.asList("Cracker", "Water", "Banana", "Apple"), Arrays.asList("1", "2", "3", "4", "5"), Arrays.asList("3", "4", "5"), Arrays.asList("1", "2"));
    }

    private void evaluate(Collection<String> items, List<String> recommendations, List<String> exclusiveRecommendations, List<String> ruleAssociations) throws Exception {
        AssociationModelEvaluator evaluator = this.createEvaluator();
        Map<FieldName, ?> arguments = AssociationAlgorithmTest.createArguments("item", items);
        Map result = evaluator.evaluate(arguments);
        Assert.assertEquals(recommendations, result.get(new FieldName("Recommendation")));
        Assert.assertEquals(exclusiveRecommendations, result.get(new FieldName("Exclusive_Recommendation")));
        Assert.assertEquals(ruleAssociations, result.get(new FieldName("Rule_Association")));
    }
}

