/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.FieldName;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.jpmml.evaluator.NormalizationUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NormalizationUtilTest {
    private NormContinuous norm;

    @Before
    public void setUp() {
        this.norm = new NormContinuous(new FieldName("x"));
        this.norm.getLinearNorms().add(new LinearNorm(0.01, 0.0));
        this.norm.getLinearNorms().add(new LinearNorm(3.07897, 0.5));
        this.norm.getLinearNorms().add(new LinearNorm(11.44, 1.0));
    }

    @Test
    public void testNormalize() {
        Assert.assertEquals((double)0.0, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)0.01), (double)1.0E-5);
        Assert.assertEquals((double)0.19583, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)1.212), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)3.07897), (double)1.0E-5);
        Assert.assertEquals((double)0.70458, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)6.5), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)11.44), (double)1.0E-5);
    }

    @Test
    public void testNormalizeOutliers() {
        Assert.assertEquals((double)-0.16455, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)-1.0), (double)1.0E-5);
        Assert.assertEquals((double)1.04544, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)12.2), (double)1.0E-5);
        this.norm.setOutliers(OutlierTreatmentMethodType.AS_MISSING_VALUES);
        this.norm.setMapMissingTo(Double.valueOf(0.5));
        Assert.assertEquals((double)0.5, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)-1.0), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)12.2), (double)1.0E-5);
        this.norm.setOutliers(OutlierTreatmentMethodType.AS_EXTREME_VALUES);
        Assert.assertEquals((double)0.0, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)-1.0), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)NormalizationUtil.normalize((NormContinuous)this.norm, (double)12.2), (double)1.0E-5);
    }

    @Test
    public void testDenormalize() {
        Assert.assertEquals((double)0.01, (double)NormalizationUtil.denormalize((NormContinuous)this.norm, (double)0.0), (double)1.0E-5);
        Assert.assertEquals((double)0.3, (double)NormalizationUtil.denormalize((NormContinuous)this.norm, (double)0.047247), (double)1.0E-5);
        Assert.assertEquals((double)7.123, (double)NormalizationUtil.denormalize((NormContinuous)this.norm, (double)0.741838), (double)1.0E-5);
        Assert.assertEquals((double)11.44, (double)NormalizationUtil.denormalize((NormContinuous)this.norm, (double)1.0), (double)1.0E-5);
    }
}

