/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.IOUtil;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.HasEntityId;

public abstract class PMMLTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PMML loadPMML(Class<? extends PMMLTest> clazz) throws Exception {
        InputStream is = clazz.getResourceAsStream("/pmml/" + clazz.getSimpleName() + ".pmml");
        try {
            PMML pMML = IOUtil.unmarshal((InputStream)is);
            return pMML;
        }
        finally {
            is.close();
        }
    }

    public static Map<FieldName, ?> createArguments(Object ... objects) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < objects.length / 2; ++i) {
            Object key = objects[i * 2];
            Object value = objects[i * 2 + 1];
            result.put(PMMLTest.toFieldName(key), value);
        }
        return result;
    }

    private static FieldName toFieldName(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return FieldName.create((String)string);
        }
        return (FieldName)object;
    }

    public static String getEntityId(Object object) {
        if (object instanceof HasEntityId) {
            HasEntityId hasEntityId = (HasEntityId)object;
            return hasEntityId.getEntityId();
        }
        return null;
    }
}

