/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.junit.Assert;
import org.junit.Test;

public class InlineTableUtilTest {
    @Test
    public void matchSingleColumn() {
        Map<String, String> first = InlineTableUtilTest.createRow(new String[][]{{"value", "1"}, {"output", "first"}});
        Map<String, String> second = InlineTableUtilTest.createRow(new String[][]{{"value", "2"}, {"output", "second"}});
        Map<String, String> third = InlineTableUtilTest.createRow(new String[][]{{"value", "3"}, {"output", "third"}});
        Table<Integer, String, String> table = InlineTableUtilTest.createTable(first, second, third);
        Assert.assertEquals(first, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", "1"}})));
        Assert.assertEquals(second, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 2}})));
        Assert.assertEquals(third, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 3.0}})));
        Assert.assertEquals(null, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", "false"}})));
    }

    @Test
    public void matchMultipleColumns() {
        Map<String, String> firstTrue = InlineTableUtilTest.createRow(new String[][]{{"value", "1"}, {"flag", "true"}, {"output", "firstTrue"}});
        Map<String, String> firstFalse = InlineTableUtilTest.createRow(new String[][]{{"value", "1"}, {"flag", "false"}, {"output", "firstFalse"}});
        Map<String, String> secondTrue = InlineTableUtilTest.createRow(new String[][]{{"value", "2"}, {"flag", "true"}, {"output", "secondTrue"}});
        Map<String, String> secondFalse = InlineTableUtilTest.createRow(new String[][]{{"value", "2"}, {"flag", "false"}, {"output", "secondFalse"}});
        Map<String, String> thirdTrue = InlineTableUtilTest.createRow(new String[][]{{"value", "3"}, {"flag", "true"}, {"output", "thirdTrue"}});
        Map<String, String> thirdFalse = InlineTableUtilTest.createRow(new String[][]{{"value", "3"}, {"flag", "false"}, {"output", "thirdFalse"}});
        Table<Integer, String, String> table = InlineTableUtilTest.createTable(firstTrue, firstFalse, secondTrue, secondFalse, thirdTrue, thirdFalse);
        Assert.assertEquals(null, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", "1"}})));
        Assert.assertEquals(firstTrue, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", "1"}, {"flag", "true"}})));
        Assert.assertEquals(firstFalse, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", "1"}, {"flag", false}})));
        Assert.assertEquals(secondTrue, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 2}, {"flag", "true"}})));
        Assert.assertEquals(secondFalse, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 2}, {"flag", false}})));
        Assert.assertEquals(thirdTrue, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 3.0}, {"flag", "true"}})));
        Assert.assertEquals(thirdFalse, (Object)InlineTableUtil.match(table, InlineTableUtilTest.createValues(new Object[][]{{"value", 3.0}, {"flag", false}})));
    }

    private static Map<String, String> createRow(String[][] strings) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (int i = 0; i < strings.length; ++i) {
            result.put(strings[i][0], strings[i][1]);
        }
        return result;
    }

    private static Table<Integer, String, String> createTable(Map<String, String> ... rows) {
        TreeBasedTable result = TreeBasedTable.create();
        for (int i = 0; i < rows.length; ++i) {
            Map<String, String> row = rows[i];
            Integer rowKey = i + 1;
            Set<Map.Entry<String, String>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                result.put((Object)rowKey, entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private static Map<String, FieldValue> createValues(Object[][] objects) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (int i = 0; i < objects.length; ++i) {
            result.put((String)objects[i][0], FieldValueUtil.create((Object)objects[i][1]));
        }
        return result;
    }
}

