/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Map;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.NaiveBayesModelEvaluator;
import org.jpmml.evaluator.NaiveBayesModelEvaluatorTest;
import org.jpmml.evaluator.VerificationUtil;
import org.junit.Assert;
import org.junit.Test;

public class TargetValueCountsTest
extends NaiveBayesModelEvaluatorTest {
    @Test
    public void evaluate() throws Exception {
        NaiveBayesModelEvaluator evaluator = this.createEvaluator();
        Map<FieldName, ?> arguments = TargetValueCountsTest.createArguments("gender", "male", "no of claims", "2", "domicile", null, "age of car", 1.0);
        Map countsMap = evaluator.getCountsMap();
        Map genderCounts = (Map)countsMap.get(new FieldName("gender"));
        Assert.assertEquals((Object)8598.0, genderCounts.get("100"));
        Assert.assertEquals((Object)2533.0, genderCounts.get("500"));
        Assert.assertEquals((Object)1522.0, genderCounts.get("1000"));
        Assert.assertEquals((Object)697.0, genderCounts.get("5000"));
        Assert.assertEquals((Object)90.0, genderCounts.get("10000"));
        Map result = evaluator.evaluate(arguments);
        ClassificationMap targetValue = (ClassificationMap)result.get(evaluator.getTargetField());
        double l0 = 11.809006821581749;
        double l1 = 0.4396757917782899;
        double l2 = 0.2019950428596748;
        double l3 = 0.015323735691282689;
        double l4 = 0.3284072249589491;
        double denominator = l0 + l1 + l2 + l3 + l4;
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)(l0 / denominator), (Number)((Number)targetValue.get((Object)"100"))));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)(l1 / denominator), (Number)((Number)targetValue.get((Object)"500"))));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)(l2 / denominator), (Number)((Number)targetValue.get((Object)"1000"))));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)(l3 / denominator), (Number)((Number)targetValue.get((Object)"5000"))));
        Assert.assertTrue((boolean)VerificationUtil.acceptable((Number)(l4 / denominator), (Number)((Number)targetValue.get((Object)"10000"))));
    }
}

