/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ParameterUtil;
import org.junit.Assert;
import org.junit.Test;

public class ParameterUtilTest {
    @Test
    public void prepare() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        MiningField miningField = new MiningField(name);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"1"));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        List fieldValues = dataField.getValues();
        Value missingValue = ParameterUtilTest.createValue("N/A", Value.Property.MISSING);
        fieldValues.add(missingValue);
        Assert.assertEquals(null, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, null));
        Assert.assertEquals(null, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"N/A"));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, null));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"N/A"));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        List fieldIntervals = dataField.getIntervals();
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED);
        validInterval.setLeftMargin(Double.valueOf(1.0));
        validInterval.setRightMargin(Double.valueOf(3.0));
        fieldIntervals.add(validInterval);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        fieldValues.clear();
        fieldIntervals.clear();
        fieldValues.add(missingValue);
        fieldValues.add(ParameterUtilTest.createValue("1", Value.Property.VALID));
        fieldValues.add(ParameterUtilTest.createValue("2", Value.Property.VALID));
        fieldValues.add(ParameterUtilTest.createValue("3", Value.Property.VALID));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        fieldValues.clear();
        fieldValues.add(missingValue);
        fieldValues.add(ParameterUtilTest.createValue("1", Value.Property.INVALID));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)5.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
    }

    @Test
    public void getDataType() {
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getDataType((Object)"value"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)1));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)1.0));
    }

    @Test
    public void getResultDataType() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1.0, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1.0, (Object)1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)Float.valueOf(1.0f), (Object)1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getResultDataType((Object)Float.valueOf(1.0f), (Object)1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1, (Object)1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getResultDataType((Object)1, (Object)Float.valueOf(1.0f)));
    }

    @Test
    public void getConstantDataType() {
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getConstantDataType((String)"1.0"));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getConstantDataType((String)"1.0E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1.0X"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getConstantDataType((String)"1"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1X"));
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value);
        result.setProperty(property);
        return result;
    }
}

