/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.NormalizationUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.UnsupportedFeatureException;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static Object evaluate(FieldName name, EvaluationContext context) {
        DerivedField derivedField = context.resolve(name);
        if (derivedField != null) {
            return ExpressionUtil.evaluate(derivedField, context);
        }
        return context.getParameter(name);
    }

    public static Object evaluate(DerivedField derivedField, EvaluationContext context) {
        Object value = ExpressionUtil.evaluate(derivedField.getExpression(), context);
        DataType dataType = derivedField.getDataType();
        if (dataType != null) {
            value = ParameterUtil.cast(dataType, value);
        }
        return value;
    }

    public static Object evaluate(Expression expression, EvaluationContext context) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            String value = constant.getValue();
            DataType dataType = constant.getDataType();
            if (dataType == null) {
                dataType = ParameterUtil.getConstantDataType(value);
            }
            return ParameterUtil.parse(dataType, value);
        }
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            Object value = ExpressionUtil.evaluate(fieldRef.getField(), context);
            if (value == null) {
                return fieldRef.getMapMissingTo();
            }
            return value;
        }
        if (expression instanceof NormContinuous) {
            NormContinuous normContinuous = (NormContinuous)expression;
            Number value = (Number)ExpressionUtil.evaluate(normContinuous.getField(), context);
            if (value == null) {
                return normContinuous.getMapMissingTo();
            }
            return NormalizationUtil.normalize(normContinuous, value.doubleValue());
        }
        if (expression instanceof NormDiscrete) {
            NormDiscrete normDiscrete = (NormDiscrete)expression;
            Object value = ExpressionUtil.evaluate(normDiscrete.getField(), context);
            if (value == null) {
                return normDiscrete.getMapMissingTo();
            }
            boolean equals = ParameterUtil.equals(value, normDiscrete.getValue());
            return equals ? 1.0 : 0.0;
        }
        if (expression instanceof Discretize) {
            Discretize discretize = (Discretize)expression;
            DataType dataType = discretize.getDataType();
            Object value = ExpressionUtil.evaluate(discretize.getField(), context);
            if (value == null) {
                return ExpressionUtil.parseSafely(dataType, discretize.getMapMissingTo());
            }
            String result = DiscretizationUtil.discretize(discretize, value);
            return ExpressionUtil.parseSafely(dataType, result);
        }
        if (expression instanceof MapValues) {
            MapValues mapValues = (MapValues)expression;
            DataType dataType = mapValues.getDataType();
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            List fieldColumnPairs = mapValues.getFieldColumnPairs();
            for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
                Object value = ExpressionUtil.evaluate(fieldColumnPair.getField(), context);
                if (value == null) {
                    return ExpressionUtil.parseSafely(dataType, mapValues.getMapMissingTo());
                }
                values.put(fieldColumnPair.getColumn(), value);
            }
            String result = DiscretizationUtil.mapValue(mapValues, values);
            return ExpressionUtil.parseSafely(dataType, result);
        }
        if (expression instanceof Apply) {
            Apply apply = (Apply)expression;
            ArrayList<Object> values = new ArrayList<Object>();
            List arguments = apply.getExpressions();
            for (Expression argument : arguments) {
                Object value = ExpressionUtil.evaluate(argument, context);
                values.add(value);
            }
            Object result = FunctionUtil.evaluate(apply.getFunction(), values);
            if (result == null) {
                return apply.getMapMissingTo();
            }
            return result;
        }
        throw new UnsupportedFeatureException((PMMLObject)expression);
    }

    private static Object parseSafely(DataType dataType, String value) {
        if (value != null && dataType != null) {
            return ParameterUtil.parse(dataType, value);
        }
        return value;
    }
}

