/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.math.BigDecimal;
import java.util.List;
import org.dmg.pmml.Node;
import org.dmg.pmml.ScoreDistribution;
import org.jpmml.evaluator.ClassificationMap;

class NodeClassificationMap
extends ClassificationMap {
    private Node node = null;
    private String score = null;

    NodeClassificationMap(Node node) {
        this.setNode(node);
        List scoreDistributions = node.getScoreDistributions();
        double sum = 0.0;
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            sum += scoreDistribution.getRecordCount();
        }
        ScoreDistribution result = null;
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            BigDecimal probability;
            if (result == null || result.getRecordCount() < scoreDistribution.getRecordCount()) {
                result = scoreDistribution;
            }
            if ((probability = scoreDistribution.getProbability()) != null) {
                this.put(scoreDistribution.getValue(), probability.doubleValue());
                continue;
            }
            this.put(scoreDistribution.getValue(), scoreDistribution.getRecordCount() / sum);
        }
        String score = node.getScore();
        if (score == null) {
            score = result.getValue();
        }
        this.setScore(score);
    }

    public String getResult() {
        return this.getScore();
    }

    public Node getNode() {
        return this.node;
    }

    private void setNode(Node node) {
        this.node = node;
    }

    public String getScore() {
        return this.score;
    }

    private void setScore(String score) {
        this.score = score;
    }
}

