/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.MultipleModelMethodType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Segment;
import org.dmg.pmml.Segmentation;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.RandomForestManager;
import org.jpmml.manager.UnsupportedFeatureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomForestEvaluator
extends RandomForestManager
implements Evaluator {
    public RandomForestEvaluator(PMML pmml) {
        super(pmml);
    }

    public RandomForestEvaluator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
    }

    public RandomForestEvaluator(RandomForestManager parent) {
        this(parent.getPmml(), parent.getModel());
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> parameters) {
        Map<FieldName, Double> predictions;
        MiningModel model = this.getModel();
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this, parameters);
        MiningFunctionType miningFunction = model.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(this, parameters, predictions);
    }

    public Map<FieldName, Double> evaluateRegression(EvaluationContext context) {
        double result;
        Segmentation segmentation = this.getSegmentation();
        double sum = 0.0;
        double weightedSum = 0.0;
        int count = 0;
        FieldName target = this.getTarget();
        List segments = this.getSegments();
        for (Segment segment : segments) {
            Predicate predicate = segment.getPredicate();
            Boolean selectable = PredicateUtil.evaluatePredicate(predicate, context);
            if (selectable == null) {
                throw new EvaluationException();
            }
            if (!selectable.booleanValue()) continue;
            TreeModel treeModel = (TreeModel)segment.getModel();
            if (treeModel == null) {
                throw new EvaluationException();
            }
            TreeModelEvaluator treeModelEvaluator = new TreeModelEvaluator(this.getPmml(), treeModel);
            Map<FieldName, ?> result2 = treeModelEvaluator.evaluate(context.getParameters());
            Object score = result2.get(target);
            if (score == null) {
                throw new EvaluationException();
            }
            Double value = ParameterUtil.toDouble(score);
            sum += value.doubleValue();
            weightedSum += segment.getWeight() * value;
            ++count;
        }
        MultipleModelMethodType multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case SUM: {
                result = sum;
                break;
            }
            case AVERAGE: {
                result = sum / (double)count;
                break;
            }
            case WEIGHTED_AVERAGE: {
                result = weightedSum / (double)count;
                break;
            }
            default: {
                throw new UnsupportedFeatureException((Enum)multipleModelMethod);
            }
        }
        return Collections.singletonMap(target, result);
    }
}

