/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvUtil {
    private CsvUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<FieldName, String>> load(InputStream is) throws IOException {
        ArrayList<Map<FieldName, String>> table = new ArrayList<Map<FieldName, String>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
        try {
            String bodyLine;
            ArrayList<FieldName> keys = new ArrayList<FieldName>();
            String headerLine = reader.readLine();
            List<String> headerCells = CsvUtil.parseLine(headerLine);
            for (int i = 0; i < headerCells.size(); ++i) {
                keys.add(new FieldName(headerCells.get(i)));
            }
            while ((bodyLine = reader.readLine()) != null) {
                LinkedHashMap row = new LinkedHashMap();
                List<String> bodyCells = CsvUtil.parseLine(bodyLine);
                if (bodyCells.size() != headerCells.size()) {
                    throw new RuntimeException();
                }
                for (int i = 0; i < bodyCells.size(); ++i) {
                    row.put(keys.get(i), bodyCells.get(i));
                }
                table.add(row);
            }
        }
        finally {
            reader.close();
        }
        return table;
    }

    private static List<String> parseLine(String line) {
        return Arrays.asList(line.split(","));
    }
}

