/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionUtilTest {
    @Test
    public void evaluateConstant() {
        Constant stringThree = new Constant("3");
        stringThree.setDataType(DataType.STRING);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtil.evaluate((Expression)stringThree, null));
        Constant integerThree = new Constant("3");
        integerThree.setDataType(DataType.INTEGER);
        Assert.assertEquals((Object)3, (Object)ExpressionUtil.evaluate((Expression)integerThree, null));
        Constant floatThree = new Constant("3");
        floatThree.setDataType(DataType.FLOAT);
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)ExpressionUtil.evaluate((Expression)floatThree, null));
    }

    @Test
    public void evaluateFieldRef() {
        FieldName name = new FieldName("x");
        FieldRef expression = new FieldRef(name);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, "3")));
        Assert.assertEquals(null, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, null)));
        expression.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, null)));
    }

    @Test
    public void evaluateNormContinuous() {
        FieldName name = new FieldName("x");
        NormContinuous expression = new NormContinuous(name);
        expression.setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, null)));
    }

    @Test
    public void evaluateNormDiscrete() {
        FieldName name = new FieldName("x");
        Double equals = 1.0;
        Double notEquals = 0.0;
        NormDiscrete stringThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtil.evaluate((Expression)stringThree, (EvaluationContext)new LocalEvaluationContext(name, "3")));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtil.evaluate((Expression)stringThree, (EvaluationContext)new LocalEvaluationContext(name, "1")));
        stringThree.setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtil.evaluate((Expression)stringThree, (EvaluationContext)new LocalEvaluationContext(name, null)));
        NormDiscrete integerThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtil.evaluate((Expression)integerThree, (EvaluationContext)new LocalEvaluationContext(name, 3)));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtil.evaluate((Expression)integerThree, (EvaluationContext)new LocalEvaluationContext(name, 1)));
        NormDiscrete floatThree = new NormDiscrete(name, "3.0");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtil.evaluate((Expression)floatThree, (EvaluationContext)new LocalEvaluationContext(name, Float.valueOf(3.0f))));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtil.evaluate((Expression)floatThree, (EvaluationContext)new LocalEvaluationContext(name, Float.valueOf(1.0f))));
    }

    @Test
    public void evaluateDiscretize() {
        FieldName name = new FieldName("x");
        Discretize expression = new Discretize(name);
        Assert.assertEquals(null, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext()));
        expression.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext()));
        Assert.assertEquals(null, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, "3")));
        expression.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, "3")));
    }

    @Test
    public void evaluateMapValues() {
        FieldName name = new FieldName("x");
        MapValues expression = new MapValues(null);
        expression.getFieldColumnPairs().add(new FieldColumnPair(name, null));
        Assert.assertEquals(null, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext()));
        expression.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext()));
        Assert.assertEquals(null, (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, "3")));
        expression.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)new LocalEvaluationContext(name, "3")));
    }
}

