/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.NoTrueChildStrategyType;
import org.dmg.pmml.Node;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.jpmml.manager.TreeModelManager;
import org.junit.Assert;
import org.junit.Test;

public class NoTrueChildStrategyTest {
    @Test
    public void returnNullPrediction() {
        TreeModelEvaluator treeModelManager = NoTrueChildStrategyTest.prepareModel(NoTrueChildStrategyType.RETURN_NULL_PREDICTION);
        FieldName name = new FieldName("prob1");
        Node node = treeModelManager.evaluateTree((EvaluationContext)new LocalEvaluationContext(name, 0.0));
        Assert.assertNull((Object)node);
        Node t1 = treeModelManager.evaluateTree((EvaluationContext)new LocalEvaluationContext(name, 1.0));
        Assert.assertNotNull((Object)t1);
        Assert.assertEquals((Object)"T1", (Object)t1.getId());
    }

    @Test
    public void returnLastPrediction() {
        TreeModelEvaluator treeModelManager = NoTrueChildStrategyTest.prepareModel(NoTrueChildStrategyType.RETURN_LAST_PREDICTION);
        FieldName name = new FieldName("prob1");
        Node n1 = treeModelManager.evaluateTree((EvaluationContext)new LocalEvaluationContext(name, 0.0));
        Assert.assertNotNull((Object)n1);
        Assert.assertEquals((Object)"N1", (Object)n1.getId());
        Node t1 = treeModelManager.evaluateTree((EvaluationContext)new LocalEvaluationContext(name, 1.0));
        Assert.assertNotNull((Object)t1);
        Assert.assertEquals((Object)"T1", (Object)t1.getId());
    }

    private static TreeModelEvaluator prepareModel(NoTrueChildStrategyType noTrueChildStrategy) {
        TreeModelManager treeModelManager = new TreeModelManager();
        TreeModel treeModel = treeModelManager.createClassificationModel();
        treeModel.setNoTrueChildStrategy(noTrueChildStrategy);
        FieldName prob1 = new FieldName("prob1");
        treeModelManager.addField(prob1, null, OpType.CONTINUOUS, DataType.DOUBLE, FieldUsageType.ACTIVE);
        Node n1 = treeModelManager.getOrCreateRoot();
        n1.setId("N1");
        n1.setScore("0");
        SimplePredicate t1Predicate = new SimplePredicate(prob1, SimplePredicate.Operator.GREATER_THAN);
        t1Predicate.setValue("0.33");
        Node t1 = treeModelManager.addNode(n1, (Predicate)t1Predicate);
        t1.setId("T1");
        t1.setScore("1");
        return new TreeModelEvaluator(treeModelManager);
    }
}

