/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FunctionUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.ParameterUtil;
import org.junit.Assert;
import org.junit.Test;

public class FunctionUtilTest {
    @Test
    public void evaluateArithmeticFunctions() {
        Assert.assertEquals((Object)4.0, (Object)FunctionUtilTest.evaluate("+", 1.0, 3.0));
        Assert.assertEquals((Object)-2.0, (Object)FunctionUtilTest.evaluate("-", 1.0, 3.0));
        Assert.assertEquals((Object)3.0, (Object)FunctionUtilTest.evaluate("*", 1.0, 3.0));
        Assert.assertEquals((Object)0.3333333333333333, (Object)FunctionUtilTest.evaluate("/", 1.0, 3.0));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("+", 1.0, null));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("+", null, 1.0));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("*", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("*", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("*", 1.0, 1.0)));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1, 1.0)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), 1.0)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("/", 1.0, 1.0)));
    }

    @Test
    public void evaluateInvalidArithmenticFunctions() {
        try {
            FunctionUtilTest.evaluate("/", 1, 0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        try {
            FunctionUtilTest.evaluate("/", Float.valueOf(1.0f), 0);
            FunctionUtilTest.evaluate("/", 1.0, 0);
        }
        catch (InvalidResultException ire) {
            Assert.fail();
        }
    }

    @Test
    public void evaluateAggregateFunctions() {
        List<Integer> values = Arrays.asList(1, 2, 3);
        Object min = FunctionUtilTest.evaluate("min", values);
        Assert.assertEquals((Object)1, (Object)min);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)min));
        Object max = FunctionUtilTest.evaluate("max", values);
        Assert.assertEquals((Object)3, (Object)max);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)max));
        Object average = FunctionUtilTest.evaluate("avg", values);
        Assert.assertEquals((Object)2.0, (Object)average);
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)average));
        Object sum = FunctionUtilTest.evaluate("sum", values);
        Assert.assertEquals((Object)6, (Object)sum);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)sum));
        Object product = FunctionUtilTest.evaluate("product", values);
        Assert.assertEquals((Object)6, (Object)product);
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)product));
    }

    @Test
    public void evaluateMathFunctions() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("log10", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("log10", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("ln", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("ln", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("exp", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("exp", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("sqrt", 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("sqrt", Float.valueOf(1.0f))));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("abs", -1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("abs", Float.valueOf(-1.0f)));
        Assert.assertEquals((Object)1.0, (Object)FunctionUtilTest.evaluate("abs", -1.0));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("pow", 1, 1)));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)FunctionUtilTest.evaluate("pow", Float.valueOf(1.0f), Float.valueOf(1.0f))));
        Assert.assertEquals((Object)0, (Object)FunctionUtilTest.evaluate("threshold", 2, 3));
        Assert.assertEquals((Object)0, (Object)FunctionUtilTest.evaluate("threshold", 3, 3));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("threshold", 3, 2));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(2.0f), Float.valueOf(3.0f)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(3.0f), Float.valueOf(3.0f)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("threshold", Float.valueOf(3.0f), Float.valueOf(2.0f)));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("floor", 1));
        Assert.assertEquals((Object)1, (Object)FunctionUtilTest.evaluate("ceil", 1));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("floor", Float.valueOf(1.99f)));
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)FunctionUtilTest.evaluate("round", Float.valueOf(1.99f)));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)FunctionUtilTest.evaluate("ceil", Float.valueOf(0.01f)));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)FunctionUtilTest.evaluate("round", Float.valueOf(0.01f)));
    }

    @Test
    public void evaluateValueFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isMissing", new Object[]{null}));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("isMissing", "value"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotMissing", "value"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("isNotMissing", new Object[]{null}));
    }

    @Test
    public void evaluateComparisonFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("equal", 1, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("equal", 1.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("notEqual", 1.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("notEqual", 1, 3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessThan", 1.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessThan", 1, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessOrEqual", 1.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("lessOrEqual", 1, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterThan", 3.0, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterThan", 3, 1.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", 3.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("greaterOrEqual", 3, 3.0));
    }

    @Test
    public void evaluateBinaryFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("and", Boolean.TRUE, Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("and", Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.FALSE, Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("or", Boolean.FALSE, Boolean.FALSE));
    }

    @Test
    public void evaluateUnaryFunction() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("not", Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FunctionUtilTest.evaluate("not", Boolean.TRUE));
    }

    @Test
    public void evaluateValueListFunctions() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", "3", "1", "2", "3"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", "0", "1", "2", "3"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", 3, 1, 2, 3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", 0, 1, 2, 3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isIn", 3.0, 1.0, 2.0, 3.0));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FunctionUtilTest.evaluate("isNotIn", 0.0, 1.0, 2.0, 3.0));
    }

    @Test
    public void evaluateIfFunction() {
        Assert.assertEquals((Object)"left", (Object)FunctionUtilTest.evaluate("if", Boolean.TRUE, "left"));
        Assert.assertEquals((Object)"left", (Object)FunctionUtilTest.evaluate("if", Boolean.TRUE, "left", "right"));
        Assert.assertEquals(null, (Object)FunctionUtilTest.evaluate("if", Boolean.FALSE, "left"));
        Assert.assertEquals((Object)"right", (Object)FunctionUtilTest.evaluate("if", Boolean.FALSE, "left", "right"));
    }

    @Test
    public void evaluateStringFunctions() {
        Assert.assertEquals((Object)"VALUE", (Object)FunctionUtilTest.evaluate("uppercase", "Value"));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("lowercase", "Value"));
        Assert.assertEquals((Object)"", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 0));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 5));
        Assert.assertEquals((Object)"alue", (Object)FunctionUtilTest.evaluate("substring", "value", 2, 4));
        Assert.assertEquals((Object)"valu", (Object)FunctionUtilTest.evaluate("substring", "value", 1, 4));
        Assert.assertEquals((Object)"value", (Object)FunctionUtilTest.evaluate("trimBlanks", "\tvalue\t"));
    }

    @Test
    public void evaluateDateTimeFunctions() {
        Assert.assertEquals((Object)15796, (Object)FunctionUtilTest.evaluate("dateDaysSinceYear", new LocalDate(2003, 4, 1), 1960));
        Assert.assertEquals((Object)15796, (Object)FunctionUtilTest.evaluate("dateDaysSinceYear", new LocalDateTime(2003, 4, 1, 0, 0, 0), 1960));
        Assert.assertEquals((Object)19410, (Object)FunctionUtilTest.evaluate("dateSecondsSinceMidnight", new LocalTime(5, 23, 30)));
        Assert.assertEquals((Object)19410, (Object)FunctionUtilTest.evaluate("dateSecondsSinceMidnight", new LocalDateTime(1960, 1, 1, 5, 23, 30)));
        Assert.assertEquals((Object)185403, (Object)FunctionUtilTest.evaluate("dateSecondsSinceYear", new LocalDateTime(1960, 1, 3, 3, 30, 3), 1960));
    }

    private static Object evaluate(String function, Object ... values) {
        return FunctionUtilTest.apply(function, Arrays.asList(values), (EvaluationContext)new LocalEvaluationContext());
    }

    private static Object evaluate(String function, List<?> values) {
        return FunctionUtilTest.apply(function, values, (EvaluationContext)new LocalEvaluationContext());
    }

    private static Object apply(String function, List<?> values, EvaluationContext context) {
        Apply apply = new Apply(function);
        return FunctionUtil.evaluate((Apply)apply, values, (EvaluationContext)context);
    }
}

