/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.Node;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.TreeModelEvaluator;
import org.jpmml.evaluator.TreeModelEvaluatorTest;
import org.junit.Assert;
import org.junit.Test;

public class MissingValueStrategyTest
extends TreeModelEvaluatorTest {
    protected static final Map<FieldName, Object> arguments = Maps.newLinkedHashMap();

    @Test
    public void nullPrediction() throws Exception {
        TreeModelEvaluator treeModelEvaluator = this.createEvaluator(MissingValueStrategyType.NULL_PREDICTION);
        Node node = treeModelEvaluator.evaluateTree((EvaluationContext)new LocalEvaluationContext(arguments));
        Assert.assertNull((Object)node);
    }

    @Test
    public void lastPrediction() throws Exception {
        TreeModelEvaluator treeModelEvaluator = this.createEvaluator(MissingValueStrategyType.LAST_PREDICTION);
        Node node = treeModelEvaluator.evaluateTree((EvaluationContext)new LocalEvaluationContext(arguments));
        Assert.assertEquals((Object)"2", (Object)node.getId());
    }

    private TreeModelEvaluator createEvaluator(MissingValueStrategyType missingValueStrategy) throws Exception {
        TreeModelEvaluator treeModelEvaluator = this.createEvaluator();
        TreeModel treeModel = treeModelEvaluator.getModel();
        treeModel.setMissingValueStrategy(missingValueStrategy);
        return treeModelEvaluator;
    }

    static {
        arguments.put(new FieldName("outlook"), "sunny");
        arguments.put(new FieldName("temperature"), null);
        arguments.put(new FieldName("humidity"), null);
    }
}

