/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.junit.Assert;
import org.junit.Test;

public class ParameterUtilTest {
    @Test
    public void prepare() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        List fieldValues = dataField.getValues();
        List fieldIntervals = dataField.getIntervals();
        MiningField miningField = new MiningField(name);
        miningField.setLowValue(Double.valueOf(1.0));
        miningField.setHighValue(Double.valueOf(3.0));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"1"));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Value missingValue = ParameterUtilTest.createValue("N/A", Value.Property.MISSING);
        fieldValues.add(missingValue);
        Assert.assertEquals(null, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, null));
        Assert.assertEquals(null, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"N/A"));
        miningField.setMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, null));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)"N/A"));
        fieldValues.clear();
        fieldIntervals.clear();
        fieldValues.add(missingValue);
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED);
        validInterval.setLeftMargin(Double.valueOf(1.0));
        validInterval.setRightMargin(Double.valueOf(3.0));
        fieldIntervals.add(validInterval);
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)-1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)-1.0));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)5.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_EXTREME_VALUES);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)-1.0));
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)3.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        miningField.setOutlierTreatment(OutlierTreatmentMethodType.AS_IS);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        fieldValues.clear();
        fieldIntervals.clear();
        ArrayList validValues = Lists.newArrayList();
        validValues.add(ParameterUtilTest.createValue("1", Value.Property.VALID));
        validValues.add(ParameterUtilTest.createValue("2", Value.Property.VALID));
        validValues.add(ParameterUtilTest.createValue("3", Value.Property.VALID));
        fieldValues.add(missingValue);
        fieldValues.addAll(validValues);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)5.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        fieldValues.clear();
        fieldIntervals.clear();
        ArrayList invalidValues = Lists.newArrayList();
        invalidValues.add(ParameterUtilTest.createValue("1", Value.Property.INVALID));
        fieldValues.add(missingValue);
        fieldValues.addAll(invalidValues);
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)5.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
        miningField.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)1.0));
        Assert.assertEquals((Object)5.0, (Object)ParameterUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)5.0));
    }

    @Test
    public void isInvalid() {
        Assert.assertFalse((boolean)ParameterUtil.isInvalid(null, null));
    }

    @Test
    public void isValid() {
        Assert.assertFalse((boolean)ParameterUtil.isValid(null, null));
    }

    @Test
    public void equals() {
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)"1", (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)1, (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)Float.valueOf(1.0f), (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)Float.valueOf(1.0f), (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)Float.valueOf(1.0f), (String)"1.0"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)1.0, (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)1.0, (String)"1"));
        Assert.assertTrue((boolean)ParameterUtil.equals((Object)1.0, (String)"1.0"));
    }

    @Test
    public void compare() {
        Assert.assertTrue((ParameterUtil.compare((Object)"1", (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)1, (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)Float.valueOf(1.0f), (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)Float.valueOf(1.0f), (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)Float.valueOf(1.0f), (String)"1.0") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)1.0, (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)1.0, (String)"1") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((Object)1.0, (String)"1.0") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareDateTime() {
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.DATE, (Object)ParameterUtilTest.parseDate("1960-01-01"), (Object)ParameterUtilTest.parseDate("1960-01-01")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.TIME, (Object)ParameterUtilTest.parseTime("00:00:00"), (Object)ParameterUtilTest.parseTime("00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.DATE_TIME, (Object)ParameterUtilTest.parseDateTime("1960-01-01T00:00:00"), (Object)ParameterUtilTest.parseDateTime("1960-01-01T00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.DATE_DAYS_SINCE_1960, (Object)ParameterUtilTest.parseDaysSince1960("1960-01-01"), (Object)ParameterUtilTest.parseDaysSince1960("1960-01-01")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.TIME_SECONDS, (Object)ParameterUtilTest.parseSecondsSinceMidnight("00:00:00"), (Object)ParameterUtilTest.parseSecondsSinceMidnight("00:00:00")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ParameterUtil.compare((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (Object)ParameterUtilTest.parseSecondsSince1960("1960-01-01T00:00:00"), (Object)ParameterUtilTest.parseSecondsSince1960("1960-01-01T00:00:00")) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void parseDaysSinceDate() {
        Assert.assertEquals((long)0L, (long)ParameterUtilTest.countDaysSince1960("1960-01-01"));
        Assert.assertEquals((long)1L, (long)ParameterUtilTest.countDaysSince1960("1960-01-02"));
        Assert.assertEquals((long)31L, (long)ParameterUtilTest.countDaysSince1960("1960-02-01"));
        Assert.assertEquals((long)-1L, (long)ParameterUtilTest.countDaysSince1960("1959-12-31"));
        Assert.assertEquals((long)15796L, (long)ParameterUtilTest.countDaysSince1960("2003-04-01"));
    }

    @Test
    public void parseSecondsSinceMidnight() {
        Assert.assertEquals((long)0L, (long)ParameterUtilTest.countSecondsSinceMidnight("0:00:00"));
        Assert.assertEquals((long)100L, (long)ParameterUtilTest.countSecondsSinceMidnight("0:01:40"));
        Assert.assertEquals((long)200L, (long)ParameterUtilTest.countSecondsSinceMidnight("0:03:20"));
        Assert.assertEquals((long)1000L, (long)ParameterUtilTest.countSecondsSinceMidnight("0:16:40"));
        Assert.assertEquals((long)86400L, (long)ParameterUtilTest.countSecondsSinceMidnight("24:00:00"));
        Assert.assertEquals((long)86401L, (long)ParameterUtilTest.countSecondsSinceMidnight("24:00:01"));
        Assert.assertEquals((long)100000L, (long)ParameterUtilTest.countSecondsSinceMidnight("27:46:40"));
        Assert.assertEquals((long)19410L, (long)ParameterUtilTest.countSecondsSinceMidnight("05:23:30"));
    }

    @Test
    public void parseSecondsSinceDate() {
        Assert.assertEquals((long)0L, (long)ParameterUtilTest.countSecondsSince1960("1960-01-01T00:00:00"));
        Assert.assertEquals((long)1L, (long)ParameterUtilTest.countSecondsSince1960("1960-01-01T00:00:01"));
        Assert.assertEquals((long)60L, (long)ParameterUtilTest.countSecondsSince1960("1960-01-01T00:01:00"));
        Assert.assertEquals((long)-1L, (long)ParameterUtilTest.countSecondsSince1960("1959-12-31T23:59:59"));
        Assert.assertEquals((long)185403L, (long)ParameterUtilTest.countSecondsSince1960("1960-01-03T03:30:03"));
    }

    @Test
    public void getDataType() {
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getDataType((Object)"value"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getDataType((Object)1));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getDataType((Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getDataType((Object)1.0));
    }

    @Test
    public void getResultDataType() {
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1.0, (Object)Float.valueOf(1.0f)));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1.0, (Object)1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)Float.valueOf(1.0f), (Object)1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getResultDataType((Object)Float.valueOf(1.0f), (Object)1));
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)ParameterUtil.getResultDataType((Object)1, (Object)1.0));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getResultDataType((Object)1, (Object)Float.valueOf(1.0f)));
    }

    @Test
    public void getConstantDataType() {
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getConstantDataType((String)"1.0"));
        Assert.assertEquals((Object)DataType.FLOAT, (Object)ParameterUtil.getConstantDataType((String)"1.0E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1.0X"));
        Assert.assertEquals((Object)DataType.INTEGER, (Object)ParameterUtil.getConstantDataType((String)"1"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1E0"));
        Assert.assertEquals((Object)DataType.STRING, (Object)ParameterUtil.getConstantDataType((String)"1X"));
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value);
        result.setProperty(property);
        return result;
    }

    private static LocalDate parseDate(String string) {
        return (LocalDate)ParameterUtil.parse((DataType)DataType.DATE, (String)string);
    }

    private static LocalTime parseTime(String string) {
        return (LocalTime)ParameterUtil.parse((DataType)DataType.TIME, (String)string);
    }

    private static LocalDateTime parseDateTime(String string) {
        return (LocalDateTime)ParameterUtil.parse((DataType)DataType.DATE_TIME, (String)string);
    }

    private static int countDaysSince1960(String string) {
        DaysSinceDate period = ParameterUtilTest.parseDaysSince1960(string);
        return period.intValue();
    }

    private static DaysSinceDate parseDaysSince1960(String string) {
        return (DaysSinceDate)ParameterUtil.parse((DataType)DataType.DATE_DAYS_SINCE_1960, (String)string);
    }

    private static int countSecondsSinceMidnight(String string) {
        SecondsSinceMidnight period = ParameterUtilTest.parseSecondsSinceMidnight(string);
        return period.intValue();
    }

    private static SecondsSinceMidnight parseSecondsSinceMidnight(String string) {
        return (SecondsSinceMidnight)ParameterUtil.parse((DataType)DataType.TIME_SECONDS, (String)string);
    }

    private static int countSecondsSince1960(String string) {
        SecondsSinceDate period = ParameterUtilTest.parseSecondsSince1960(string);
        return period.intValue();
    }

    private static SecondsSinceDate parseSecondsSince1960(String string) {
        return (SecondsSinceDate)ParameterUtil.parse((DataType)DataType.DATE_TIME_SECONDS_SINCE_1960, (String)string);
    }
}

