/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.Association;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelManagerEvaluationContext;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ParameterUtil;
import org.jpmml.manager.AssociationModelManager;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.ModelManager;
import org.jpmml.manager.UnsupportedFeatureException;

public class AssociationModelEvaluator
extends AssociationModelManager
implements Evaluator {
    private BiMap<String, Item> items = null;
    private BiMap<String, Itemset> itemsets = null;
    private BiMap<String, AssociationRule> entities = null;
    private BiMap<String, String> itemValues = null;

    public AssociationModelEvaluator(PMML pmml) {
        super(pmml);
    }

    public AssociationModelEvaluator(PMML pmml, AssociationModel associationModel) {
        super(pmml, associationModel);
    }

    public AssociationModelEvaluator(AssociationModelManager parent) {
        super(parent.getPmml(), parent.getModel());
    }

    public BiMap<String, Item> getItemRegistry() {
        if (this.items == null) {
            this.items = super.getItemRegistry();
        }
        return this.items;
    }

    public BiMap<String, Itemset> getItemsetRegistry() {
        if (this.itemsets == null) {
            this.itemsets = super.getItemsetRegistry();
        }
        return this.itemsets;
    }

    public BiMap<String, AssociationRule> getEntityRegistry() {
        if (this.entities == null) {
            this.entities = super.getEntityRegistry();
        }
        return this.entities;
    }

    @Override
    public Object prepare(FieldName name, Object value) {
        return ParameterUtil.prepare(this.getDataField(name), this.getMiningField(name), value);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        Map<FieldName, ?> predictions;
        AssociationModel associationModel = this.getModel();
        if (!associationModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)associationModel);
        }
        ModelManagerEvaluationContext context = new ModelManagerEvaluationContext((ModelManager<?>)this, arguments);
        MiningFunctionType miningFunction = associationModel.getFunctionName();
        switch (miningFunction) {
            case ASSOCIATION_RULES: {
                predictions = this.evaluate(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)associationModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    Map<FieldName, ?> evaluate(EvaluationContext context) {
        AssociationModel associationModel = this.getModel();
        FieldName activeField = this.getActiveField();
        Object value = context.getArgument(activeField);
        if (value == null) {
            throw new MissingFieldException(activeField, (PMMLObject)associationModel);
        }
        Set<String> input = this.createInput((Collection)value);
        LinkedHashMap flags = Maps.newLinkedHashMap();
        List itemsets = this.getItemsets();
        for (Itemset itemset : itemsets) {
            flags.put(itemset.getId(), AssociationModelEvaluator.isSubset(input, itemset));
        }
        List associationRules = this.getAssociationRules();
        BitSet antecedentFlags = new BitSet(associationRules.size());
        BitSet consequentFlags = new BitSet(associationRules.size());
        for (int i = 0; i < associationRules.size(); ++i) {
            AssociationRule associationRule = (AssociationRule)associationRules.get(i);
            Boolean antecedentFlag = (Boolean)flags.get(associationRule.getAntecedent());
            if (antecedentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            antecedentFlags.set(i, antecedentFlag);
            Boolean consequentFlag = (Boolean)flags.get(associationRule.getConsequent());
            if (consequentFlag == null) {
                throw new InvalidFeatureException((PMMLObject)associationRule);
            }
            consequentFlags.set(i, consequentFlag);
        }
        Association association = new Association(associationRules, antecedentFlags, consequentFlags){

            @Override
            public BiMap<String, Item> getItemRegistry() {
                return AssociationModelEvaluator.this.getItemRegistry();
            }

            @Override
            public BiMap<String, Itemset> getItemsetRegistry() {
                return AssociationModelEvaluator.this.getItemsetRegistry();
            }

            @Override
            public BiMap<String, AssociationRule> getAssociationRuleRegistry() {
                return AssociationModelEvaluator.this.getEntityRegistry();
            }
        };
        return Collections.singletonMap(this.getTargetField(), association);
    }

    private Set<String> createInput(Collection<?> values) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        BiMap valueItems = this.getItemValues().inverse();
        for (Object value : values) {
            String stringValue = (String)ParameterUtil.cast(DataType.STRING, value);
            String id = (String)valueItems.get(stringValue);
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    private BiMap<String, String> getItemValues() {
        if (this.itemValues == null) {
            this.itemValues = this.createItemValues();
        }
        return this.itemValues;
    }

    private BiMap<String, String> createItemValues() {
        HashBiMap result = HashBiMap.create();
        List items = this.getItems();
        for (Item item : items) {
            result.put((Object)item.getId(), (Object)item.getValue());
        }
        return result;
    }

    private static boolean isSubset(Set<String> input, Itemset itemset) {
        boolean result = true;
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            if (result &= input.contains(itemRef.getItemRef())) continue;
            return false;
        }
        return result;
    }
}

