/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.Interval;
import org.jpmml.evaluator.DiscretizationUtil;
import org.junit.Assert;
import org.junit.Test;

public class DiscretizationUtilTest {
    @Test
    public void contains() {
        Double min = -2.147483648E9;
        Double max = 2.147483647E9;
        Interval negative = DiscretizationUtilTest.createInterval(Interval.Closure.OPEN_OPEN, min, 0.0);
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)negative, (double)-1.0));
        Assert.assertFalse((boolean)DiscretizationUtil.contains((Interval)negative, (double)0.0));
        Interval negativeNull = DiscretizationUtilTest.createInterval(Interval.Closure.OPEN_OPEN, null, 0.0);
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)negativeNull, (double)-1.0));
        Assert.assertFalse((boolean)DiscretizationUtil.contains((Interval)negativeNull, (double)0.0));
        Interval positive = DiscretizationUtilTest.createInterval(Interval.Closure.OPEN_OPEN, 0.0, max);
        Assert.assertFalse((boolean)DiscretizationUtil.contains((Interval)positive, (double)0.0));
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)positive, (double)1.0));
        Interval positiveNull = DiscretizationUtilTest.createInterval(Interval.Closure.OPEN_OPEN, 0.0, null);
        Assert.assertFalse((boolean)DiscretizationUtil.contains((Interval)positiveNull, (double)0.0));
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)positiveNull, (double)1.0));
        Interval negativeAndZero = DiscretizationUtilTest.createInterval(Interval.Closure.OPEN_CLOSED, min, 0.0);
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)negativeAndZero, (double)-1.0));
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)negativeAndZero, (double)0.0));
        Interval zeroAndPositive = DiscretizationUtilTest.createInterval(Interval.Closure.CLOSED_OPEN, 0.0, max);
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)zeroAndPositive, (double)0.0));
        Assert.assertTrue((boolean)DiscretizationUtil.contains((Interval)zeroAndPositive, (double)1.0));
    }

    private static Interval createInterval(Interval.Closure closure, Double left, Double right) {
        Interval interval = new Interval(closure);
        interval.setLeftMargin(left);
        interval.setRightMargin(right);
        return interval;
    }
}

