/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.LocalEvaluationContext;
import org.jpmml.evaluator.TypeUtil;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionUtilTest {
    @Test
    public void evaluateConstant() {
        Constant constant = new Constant("3");
        constant.setDataType(DataType.STRING);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)constant, null));
        Constant integerThree = new Constant("3");
        integerThree.setDataType(DataType.INTEGER);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, null));
        Constant floatThree = new Constant("3");
        floatThree.setDataType(DataType.FLOAT);
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)ExpressionUtilTest.evaluate((Expression)floatThree, null));
    }

    @Test
    public void evaluateFieldRef() {
        FieldName name = new FieldName("x");
        FieldRef fieldRef = new FieldRef(name);
        Assert.assertEquals((Object)"3", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, ExpressionUtilTest.createContext(name, "3")));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, ExpressionUtilTest.createContext(name, null)));
        fieldRef.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)fieldRef, ExpressionUtilTest.createContext(name, null)));
    }

    @Test
    public void evaluateNormContinuous() {
        FieldName name = new FieldName("x");
        NormContinuous normContinuous = new NormContinuous(name);
        normContinuous.setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)normContinuous, ExpressionUtilTest.createContext(name, null)));
    }

    @Test
    public void evaluateNormDiscrete() {
        FieldName name = new FieldName("x");
        Double equals = 1.0;
        Double notEquals = 0.0;
        NormDiscrete stringThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, ExpressionUtilTest.createContext(name, "3")));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, ExpressionUtilTest.createContext(name, "1")));
        stringThree.setMapMissingTo(Double.valueOf(5.0));
        Assert.assertEquals((Object)5.0, (Object)ExpressionUtilTest.evaluate((Expression)stringThree, ExpressionUtilTest.createContext(name, null)));
        NormDiscrete integerThree = new NormDiscrete(name, "3");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, ExpressionUtilTest.createContext(name, 3)));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)integerThree, ExpressionUtilTest.createContext(name, 1)));
        NormDiscrete floatThree = new NormDiscrete(name, "3.0");
        Assert.assertEquals((Object)equals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, ExpressionUtilTest.createContext(name, Float.valueOf(3.0f))));
        Assert.assertEquals((Object)notEquals, (Object)ExpressionUtilTest.evaluate((Expression)floatThree, ExpressionUtilTest.createContext(name, Float.valueOf(1.0f))));
    }

    @Test
    public void evaluateDiscretize() {
        FieldName name = new FieldName("x");
        Discretize discretize = new Discretize(name);
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize, ExpressionUtilTest.createContext()));
        discretize.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)discretize, ExpressionUtilTest.createContext()));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)discretize, ExpressionUtilTest.createContext(name, 3)));
        discretize.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)discretize, ExpressionUtilTest.createContext(name, 3)));
    }

    @Test
    public void evaluateMapValues() {
        FieldName name = new FieldName("x");
        MapValues mapValues = new MapValues(null);
        mapValues.withFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, null)});
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues, ExpressionUtilTest.createContext()));
        mapValues.setMapMissingTo("Missing");
        Assert.assertEquals((Object)"Missing", (Object)ExpressionUtilTest.evaluate((Expression)mapValues, ExpressionUtilTest.createContext()));
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)mapValues, ExpressionUtilTest.createContext(name, "3")));
        mapValues.setDefaultValue("Default");
        Assert.assertEquals((Object)"Default", (Object)ExpressionUtilTest.evaluate((Expression)mapValues, ExpressionUtilTest.createContext(name, "3")));
    }

    @Test
    public void evaluateApply() {
        FieldName name = new FieldName("x");
        Apply apply = new Apply("/");
        apply.withExpressions(new Expression[]{new FieldRef(name), new Constant("0")});
        Assert.assertEquals(null, (Object)ExpressionUtilTest.evaluate((Expression)apply, ExpressionUtilTest.createContext(name, null)));
        apply.setDefaultValue("1");
        Assert.assertEquals((Object)"1", (Object)ExpressionUtilTest.evaluate((Expression)apply, ExpressionUtilTest.createContext(name, null)));
        apply.setMapMissingTo("missing");
        Assert.assertEquals((Object)"missing", (Object)ExpressionUtilTest.evaluate((Expression)apply, ExpressionUtilTest.createContext(name, null)));
        apply.setInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID);
        try {
            ExpressionUtilTest.evaluate((Expression)apply, ExpressionUtilTest.createContext(name, 1));
            Assert.fail();
        }
        catch (InvalidResultException invalidResultException) {
            // empty catch block
        }
        apply.setInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)"1", (Object)ExpressionUtilTest.evaluate((Expression)apply, ExpressionUtilTest.createContext(name, 1)));
    }

    @Test
    public void evaluateAggregate() {
        FieldName name = new FieldName("x");
        List<Object> values = Arrays.asList(TypeUtil.parse((DataType)DataType.DATE, (String)"2013-01-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-02-01"), TypeUtil.parse((DataType)DataType.DATE, (String)"2013-03-01"));
        EvaluationContext context = ExpressionUtilTest.createContext(name, values);
        Aggregate aggregate = new Aggregate(name, Aggregate.Function.COUNT);
        Assert.assertEquals((Object)3, (Object)ExpressionUtilTest.evaluate((Expression)aggregate, context));
        aggregate.setFunction(Aggregate.Function.MIN);
        Assert.assertEquals((Object)values.get(0), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, context));
        aggregate.setFunction(Aggregate.Function.MAX);
        Assert.assertEquals((Object)values.get(2), (Object)ExpressionUtilTest.evaluate((Expression)aggregate, context));
    }

    private static EvaluationContext createContext() {
        LocalEvaluationContext context = new LocalEvaluationContext();
        return context;
    }

    private static EvaluationContext createContext(FieldName name, Object value) {
        LocalEvaluationContext context = new LocalEvaluationContext();
        context.declare(name, value);
        return context;
    }

    private static Object evaluate(Expression expression, EvaluationContext context) {
        FieldValue result = ExpressionUtil.evaluate((Expression)expression, (EvaluationContext)context);
        return FieldValueUtil.getValue((FieldValue)result);
    }
}

