/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.MissingResultException;

@Beta
public class ClassificationMap<K>
extends LinkedHashMap<K, Double>
implements Computable {
    private Type type = null;

    protected ClassificationMap(Type type) {
        this.setType(type);
    }

    @Override
    public Object getResult() {
        Map.Entry<K, Double> entry = this.getWinner();
        if (entry == null) {
            throw new MissingResultException(null);
        }
        return entry.getKey();
    }

    Double getFeature(String value) {
        Double result = (Double)this.get(value);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    Map.Entry<K, Double> getWinner() {
        Map.Entry result = null;
        Type type = this.getType();
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (result != null && type.compare((Double)entry.getValue(), (Double)result.getValue()) <= 0) continue;
            result = entry;
        }
        return result;
    }

    List<Map.Entry<K, Double>> getWinnerList() {
        ArrayList result = Lists.newArrayList(this.entrySet());
        final Type type = this.getType();
        Comparator comparator = new Comparator<Map.Entry<K, Double>>(){

            @Override
            public int compare(Map.Entry<K, Double> left, Map.Entry<K, Double> right) {
                return -1 * type.compare(left.getValue(), right.getValue());
            }
        };
        Collections.sort(result, comparator);
        return result;
    }

    List<K> getWinnerKeys() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, K>(){

            public K apply(Map.Entry<K, Double> entry) {
                return entry.getKey();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    List<Double> getWinnerValues() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, Double>(){

            public Double apply(Map.Entry<K, Double> entry) {
                return entry.getValue();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    void normalizeValues() {
        double sum = 0.0;
        Collection values = this.values();
        for (Double value : values) {
            sum += value.doubleValue();
        }
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            entry.setValue((Double)entry.getValue() / sum);
        }
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public static enum Type implements Comparator<Double>
    {
        PROBABILITY(Ordering.INCREASING),
        CONFIDENCE(Ordering.INCREASING),
        DISTANCE(Ordering.DECREASING),
        SIMILARITY(Ordering.INCREASING),
        VOTE(Ordering.INCREASING);

        private Ordering ordering;

        private Type(Ordering ordering) {
            this.setOrdering(ordering);
        }

        @Override
        public int compare(Double left, Double right) {
            int order = left.compareTo(right);
            Ordering ordering = this.getOrdering();
            switch (ordering) {
                case INCREASING: {
                    return order;
                }
                case DECREASING: {
                    return -1 * order;
                }
            }
            throw new IllegalStateException();
        }

        public Ordering getOrdering() {
            return this.ordering;
        }

        private void setOrdering(Ordering ordering) {
            this.ordering = ordering;
        }

        private static enum Ordering {
            INCREASING,
            DECREASING;

        }
    }
}

