/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.DataType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Seconds;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AbstractFunction;
import org.jpmml.evaluator.functions.AggregateFunction;
import org.jpmml.evaluator.functions.ArithmeticFunction;
import org.jpmml.evaluator.functions.BinaryBooleanFunction;
import org.jpmml.evaluator.functions.ComparisonFunction;
import org.jpmml.evaluator.functions.EqualityFunction;
import org.jpmml.evaluator.functions.FpMathFunction;
import org.jpmml.evaluator.functions.MathFunction;
import org.jpmml.evaluator.functions.StringFunction;
import org.jpmml.evaluator.functions.UnaryBooleanFunction;
import org.jpmml.evaluator.functions.ValueFunction;
import org.jpmml.evaluator.functions.ValueListFunction;

public class FunctionRegistry {
    private static final Map<String, Function> functions = Maps.newLinkedHashMap();

    private FunctionRegistry() {
    }

    public static Function getFunction(String name) {
        return functions.get(name);
    }

    public static void putFunction(String name, Function function) {
        functions.put(name, function);
    }

    static {
        FunctionRegistry.putFunction("+", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() + right.doubleValue();
            }
        });
        FunctionRegistry.putFunction("-", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() - right.doubleValue();
            }
        });
        FunctionRegistry.putFunction("*", new ArithmeticFunction(){

            @Override
            public Double evaluate(Number left, Number right) {
                return left.doubleValue() * right.doubleValue();
            }
        });
        FunctionRegistry.putFunction("/", new ArithmeticFunction(){

            @Override
            public Number evaluate(Number left, Number right) {
                if (left instanceof Integer && right instanceof Integer) {
                    return left.intValue() / right.intValue();
                }
                return left.doubleValue() / right.doubleValue();
            }
        });
        FunctionRegistry.putFunction("min", new AggregateFunction(){

            public Min createStatistic() {
                return new Min();
            }
        });
        FunctionRegistry.putFunction("max", new AggregateFunction(){

            public Max createStatistic() {
                return new Max();
            }
        });
        FunctionRegistry.putFunction("avg", new AggregateFunction(){

            public Mean createStatistic() {
                return new Mean();
            }

            @Override
            public DataType getResultType(DataType dataType) {
                return 7.integerToDouble(dataType);
            }
        });
        FunctionRegistry.putFunction("sum", new AggregateFunction(){

            public Sum createStatistic() {
                return new Sum();
            }
        });
        FunctionRegistry.putFunction("product", new AggregateFunction(){

            public Product createStatistic() {
                return new Product();
            }
        });
        FunctionRegistry.putFunction("log10", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log10(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction("ln", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.log(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction("exp", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.exp(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction("sqrt", new FpMathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.sqrt(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction("abs", new MathFunction(){

            @Override
            public Double evaluate(Number value) {
                return Math.abs(value.doubleValue());
            }
        });
        FunctionRegistry.putFunction("pow", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                15.checkArguments(values, 2);
                FieldValue left = values.get(0);
                FieldValue right = values.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Double result = Math.pow(left.asNumber().doubleValue(), right.asNumber().doubleValue());
                return FieldValueUtil.create(15.cast(dataType, result));
            }
        });
        FunctionRegistry.putFunction("threshold", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                16.checkArguments(values, 2);
                FieldValue left = values.get(0);
                FieldValue right = values.get(1);
                DataType dataType = TypeUtil.getResultDataType(left.getDataType(), right.getDataType());
                Integer result = left.asNumber().doubleValue() > right.asNumber().doubleValue() ? 1 : 0;
                return FieldValueUtil.create(16.cast(dataType, result));
            }
        });
        FunctionRegistry.putFunction("floor", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.floor(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction("ceil", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.ceil(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction("round", new MathFunction(){

            @Override
            public Double evaluate(Number number) {
                return Math.round(number.doubleValue());
            }
        });
        FunctionRegistry.putFunction("isMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value == null;
            }
        });
        FunctionRegistry.putFunction("isNotMissing", new ValueFunction(){

            @Override
            public Boolean evaluate(FieldValue value) {
                return value != null;
            }
        });
        FunctionRegistry.putFunction("equal", new EqualityFunction(){

            @Override
            public Boolean evaluate(boolean equals) {
                return equals;
            }
        });
        FunctionRegistry.putFunction("notEqual", new EqualityFunction(){

            @Override
            public Boolean evaluate(boolean equals) {
                return !equals;
            }
        });
        FunctionRegistry.putFunction("lessThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order < 0;
            }
        });
        FunctionRegistry.putFunction("lessOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order <= 0;
            }
        });
        FunctionRegistry.putFunction("greaterThan", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order > 0;
            }
        });
        FunctionRegistry.putFunction("greaterOrEqual", new ComparisonFunction(){

            @Override
            public Boolean evaluate(int order) {
                return order >= 0;
            }
        });
        FunctionRegistry.putFunction("and", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left & right;
            }
        });
        FunctionRegistry.putFunction("or", new BinaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean left, Boolean right) {
                return left | right;
            }
        });
        FunctionRegistry.putFunction("not", new UnaryBooleanFunction(){

            @Override
            public Boolean evaluate(Boolean value) {
                return value == false;
            }
        });
        FunctionRegistry.putFunction("isIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return value.equalsAnyValue(values);
            }
        });
        FunctionRegistry.putFunction("isNotIn", new ValueListFunction(){

            @Override
            public Boolean evaluate(FieldValue value, List<FieldValue> values) {
                return !value.equalsAnyValue(values);
            }
        });
        FunctionRegistry.putFunction("if", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                FieldValue falseValue;
                if (values.size() < 2 || values.size() > 3) {
                    throw new EvaluationException();
                }
                FieldValue flag = values.get(0);
                if (flag == null) {
                    throw new EvaluationException();
                }
                if (flag.asBoolean().booleanValue()) {
                    FieldValue trueValue = values.get(1);
                    if (trueValue == null) {
                        throw new EvaluationException();
                    }
                    return trueValue;
                }
                FieldValue fieldValue = falseValue = values.size() > 2 ? values.get(2) : null;
                if (falseValue == null) {
                    return null;
                }
                return falseValue;
            }
        });
        FunctionRegistry.putFunction("uppercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toUpperCase();
            }
        });
        FunctionRegistry.putFunction("lowercase", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.toLowerCase();
            }
        });
        FunctionRegistry.putFunction("substring", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                36.checkArguments(values, 3);
                String string = values.get(0).asString();
                int position = values.get(1).asInteger();
                int length = values.get(2).asInteger();
                if (position <= 0 || length < 0) {
                    throw new EvaluationException();
                }
                String result = string.substring(position - 1, position + length - 1);
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction("trimBlanks", new StringFunction(){

            @Override
            public String evaluate(String value) {
                return value.trim();
            }
        });
        FunctionRegistry.putFunction("concat", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                38.checkVariableArguments(values, 2);
                StringBuilder sb = new StringBuilder();
                for (FieldValue value : values) {
                    String string = (String)TypeUtil.cast(DataType.STRING, value.getValue());
                    sb.append(string);
                }
                return FieldValueUtil.create(sb.toString());
            }
        });
        FunctionRegistry.putFunction("replace", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                39.checkArguments(values, 3);
                String input = values.get(0).asString();
                String pattern = values.get(1).asString();
                String replacement = values.get(2).asString();
                Matcher matcher = Pattern.compile(pattern).matcher(input);
                String result = matcher.replaceAll(replacement);
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction("matches", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                40.checkArguments(values, 2);
                String input = values.get(0).asString();
                String pattern = values.get(1).asString();
                Matcher matcher = Pattern.compile(pattern).matcher(input);
                Boolean result = matcher.find();
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction("formatNumber", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                41.checkArguments(values, 2);
                FieldValue value = values.get(0);
                FieldValue pattern = values.get(1);
                String result = String.format(pattern.asString(), value.asNumber());
                return FieldValueUtil.create(result);
            }
        });
        FunctionRegistry.putFunction("formatDatetime", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                42.checkArguments(values, 2);
                FieldValue value = values.get(0);
                FieldValue pattern = values.get(1);
                String result = String.format(this.translatePattern(pattern.asString()), value.asDateTime().toDate());
                return FieldValueUtil.create(result);
            }

            private String translatePattern(String pattern) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < pattern.length(); ++i) {
                    char c = pattern.charAt(i);
                    sb.append(c);
                    if (c != '%' || i >= pattern.length() - 1 || pattern.charAt(i + 1) == '%') continue;
                    sb.append("1$t");
                }
                return sb.toString();
            }
        });
        FunctionRegistry.putFunction("dateDaysSinceYear", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                43.checkArguments(values, 2);
                LocalDate instant = values.get(0).asLocalDate();
                int year = values.get(1).asInteger();
                DaysSinceDate period = new DaysSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionRegistry.putFunction("dateSecondsSinceMidnight", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                44.checkArguments(values, 1);
                LocalTime instant = values.get(0).asLocalTime();
                Seconds seconds = Seconds.seconds((int)(instant.getHourOfDay() * 60 * 60 + instant.getMinuteOfHour() * 60 + instant.getSecondOfMinute()));
                SecondsSinceMidnight period = new SecondsSinceMidnight(seconds);
                return FieldValueUtil.create(period.intValue());
            }
        });
        FunctionRegistry.putFunction("dateSecondsSinceYear", new AbstractFunction(){

            @Override
            public FieldValue evaluate(List<FieldValue> values) {
                45.checkArguments(values, 2);
                LocalDateTime instant = values.get(0).asLocalDateTime();
                int year = values.get(1).asInteger();
                SecondsSinceDate period = new SecondsSinceDate(year, instant);
                return FieldValueUtil.create(period.intValue());
            }
        });
    }
}

