/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.DefineFunctionEvaluationContext;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static FieldValue evaluate(Apply apply, List<FieldValue> values, EvaluationContext context) {
        String name = apply.getFunction();
        Function function = FunctionRegistry.getFunction(name);
        if (function == null) {
            DefineFunction defineFunction = context.resolveFunction(name);
            if (defineFunction == null) {
                throw new UnsupportedFeatureException((PMMLObject)apply);
            }
            return FunctionUtil.evaluate(defineFunction, values, context);
        }
        return function.evaluate(values);
    }

    public static FieldValue evaluate(DefineFunction defineFunction, List<FieldValue> values, EvaluationContext context) {
        List parameterFields = defineFunction.getParameterFields();
        if (parameterFields.size() < 1) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        if (parameterFields.size() != values.size()) {
            throw new EvaluationException();
        }
        DefineFunctionEvaluationContext functionContext = new DefineFunctionEvaluationContext(context);
        for (int i = 0; i < parameterFields.size(); ++i) {
            ParameterField parameterField = (ParameterField)parameterFields.get(i);
            FieldValue value = FieldValueUtil.refine((Field)parameterField, values.get(i));
            functionContext.declare(parameterField.getName(), value);
        }
        Expression expression = defineFunction.getExpression();
        if (expression == null) {
            throw new InvalidFeatureException((PMMLObject)defineFunction);
        }
        FieldValue result = ExpressionUtil.evaluate(expression, (EvaluationContext)functionContext);
        return FieldValueUtil.refine(defineFunction.getDataType(), defineFunction.getOptype(), result);
    }
}

