/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.Function;

public abstract class AbstractFunction
implements Function {
    protected static void checkArguments(List<FieldValue> values, int size) {
        AbstractFunction.checkArguments(values, size, false);
    }

    protected static void checkArguments(List<FieldValue> values, int size, boolean allowNulls) {
        boolean success;
        boolean bl = success = values.size() == size && (allowNulls || !values.contains(null));
        if (!success) {
            throw new EvaluationException();
        }
    }

    protected static void checkVariableArguments(List<FieldValue> values, int size) {
        AbstractFunction.checkVariableArguments(values, size, false);
    }

    protected static void checkVariableArguments(List<FieldValue> values, int size, boolean allowNulls) {
        boolean success;
        boolean bl = success = values.size() >= size && (allowNulls || !values.contains(null));
        if (!success) {
            throw new EvaluationException();
        }
    }

    protected static Number cast(DataType dataType, Number number) {
        switch (dataType) {
            case INTEGER: {
                if (number instanceof Integer) {
                    return number;
                }
                return number.intValue();
            }
            case FLOAT: {
                if (number instanceof Float) {
                    return number;
                }
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                if (number instanceof Double) {
                    return number;
                }
                return number.doubleValue();
            }
        }
        throw new EvaluationException();
    }

    protected static DataType integerToDouble(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return DataType.DOUBLE;
            }
        }
        return dataType;
    }
}

