/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class ArgumentUtil {
    private static final LoadingCache<TypeDefinitionField, List<String>> targetCategoryCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<TypeDefinitionField, List<String>>(){

        public List<String> load(TypeDefinitionField field) {
            List<Value> values = ArgumentUtil.getValidValues(field);
            Function<Value, String> function = new Function<Value, String>(){

                public String apply(Value value) {
                    String result = value.getValue();
                    if (result == null) {
                        throw new InvalidFeatureException((PMMLObject)value);
                    }
                    return result;
                }
            };
            return ImmutableList.copyOf((Iterable)Iterables.transform(values, (Function)function));
        }
    });
    private static final LoadingCache<DataField, RangeSet<Double>> validRangeCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<DataField, RangeSet<Double>>(){

        public RangeSet<Double> load(DataField dataField) {
            return ImmutableRangeSet.copyOf((RangeSet)ArgumentUtil.parseValidRanges(dataField));
        }
    });

    private ArgumentUtil() {
    }

    public static FieldValue prepare(DataField dataField, MiningField miningField, Object value) {
        if (value != null) {
            DataType dataType = dataField.getDataType();
            try {
                value = TypeUtil.parseOrCast(dataType, value);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (ArgumentUtil.isOutlier(dataField, value)) {
            OutlierTreatmentMethodType outlierTreatmentMethod = miningField.getOutlierTreatment();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    break;
                }
                case AS_MISSING_VALUES: {
                    value = null;
                    break;
                }
                case AS_EXTREME_VALUES: {
                    Double lowValue = miningField.getLowValue();
                    Double highValue = miningField.getHighValue();
                    if (lowValue == null || highValue == null) {
                        throw new InvalidFeatureException((PMMLObject)miningField);
                    }
                    if (lowValue.compareTo(highValue) > 0) {
                        throw new InvalidFeatureException((PMMLObject)miningField);
                    }
                    Double doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                    if (TypeUtil.compare(DataType.DOUBLE, doubleValue, lowValue) < 0) {
                        value = lowValue;
                        break;
                    }
                    if (TypeUtil.compare(DataType.DOUBLE, doubleValue, highValue) <= 0) break;
                    value = highValue;
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum)outlierTreatmentMethod);
                }
            }
        }
        if (ArgumentUtil.isMissing(dataField, value) && (value = miningField.getMissingValueReplacement()) == null) {
            return null;
        }
        if (ArgumentUtil.isInvalid(dataField, value)) {
            InvalidValueTreatmentMethodType invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
            switch (invalidValueTreatmentMethod) {
                case RETURN_INVALID: {
                    throw new InvalidResultException((PMMLObject)miningField);
                }
                case AS_IS: {
                    break;
                }
                case AS_MISSING: {
                    value = miningField.getMissingValueReplacement();
                    if (value != null) break;
                    return null;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum)invalidValueTreatmentMethod);
                }
            }
        }
        return FieldValueUtil.create((Field)dataField, value);
    }

    public static boolean isOutlier(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        List intervals = dataField.getIntervals();
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                Double doubleValue;
                if (intervals.size() <= 0) break;
                RangeSet<Double> validRange = CacheUtil.getValue(dataField, validRangeCache);
                Range validRangeSpan = validRange.span();
                return !validRangeSpan.contains((Comparable)(doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value)));
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
            }
        }
        return false;
    }

    public static boolean isMissing(DataField dataField, Object value) {
        if (value == null) {
            return true;
        }
        DataType dataType = dataField.getDataType();
        List fieldValues = dataField.getValues();
        block3: for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case MISSING: {
                    boolean equals = ArgumentUtil.equals(dataType, value, fieldValue.getValue());
                    if (!equals) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInvalid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        return !ArgumentUtil.isValid(dataField, value);
    }

    public static boolean isValid(DataField dataField, Object value) {
        if (value == null) {
            return false;
        }
        DataType dataType = dataField.getDataType();
        List intervals = dataField.getIntervals();
        OpType opType = dataField.getOptype();
        switch (opType) {
            case CONTINUOUS: {
                if (intervals.size() > 0) {
                    RangeSet<Double> validRanges = CacheUtil.getValue(dataField, validRangeCache);
                    Double doubleValue = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, value);
                    return validRanges.contains((Comparable)doubleValue);
                }
            }
            case CATEGORICAL: 
            case ORDINAL: {
                if (intervals.size() > 0) {
                    throw new InvalidFeatureException((PMMLObject)dataField);
                }
                int validValueCount = 0;
                List fieldValues = dataField.getValues();
                block8: for (Value fieldValue : fieldValues) {
                    Value.Property property = fieldValue.getProperty();
                    switch (property) {
                        case VALID: {
                            ++validValueCount;
                            boolean equals = ArgumentUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block8;
                            return true;
                        }
                        case MISSING: 
                        case INVALID: {
                            boolean equals = ArgumentUtil.equals(dataType, value, fieldValue.getValue());
                            if (!equals) continue block8;
                            return false;
                        }
                        default: {
                            throw new UnsupportedFeatureException((PMMLObject)fieldValue, (Enum)property);
                        }
                    }
                }
                return validValueCount <= 0;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
    }

    public static Value getValidValue(TypeDefinitionField field, Object value) {
        DataType dataType = field.getDataType();
        List fieldValues = field.getValues();
        block3: for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case VALID: {
                    boolean equals = ArgumentUtil.equals(dataType, value, fieldValue.getValue());
                    if (!equals) continue block3;
                    return fieldValue;
                }
            }
        }
        return null;
    }

    public static List<Value> getValidValues(TypeDefinitionField field) {
        List fieldValues = field.getValues();
        if (fieldValues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Value fieldValue : fieldValues) {
            Value.Property property = fieldValue.getProperty();
            switch (property) {
                case VALID: {
                    result.add(fieldValue);
                    break;
                }
            }
        }
        return result;
    }

    private static boolean equals(DataType dataType, Object value, String referenceValue) {
        try {
            return TypeUtil.equals(dataType, value, TypeUtil.parseOrCast(dataType, referenceValue));
        }
        catch (IllegalArgumentException iae) {
            try {
                return TypeUtil.equals(DataType.STRING, value, referenceValue);
            }
            catch (TypeCheckException tce) {
                throw iae;
            }
        }
    }

    public static List<String> getTargetCategories(TypeDefinitionField field) {
        return CacheUtil.getValue(field, targetCategoryCache);
    }

    private static RangeSet<Double> parseValidRanges(DataField dataField) {
        TreeRangeSet result = TreeRangeSet.create();
        List intervals = dataField.getIntervals();
        for (Interval interval : intervals) {
            Range<Double> range = DiscretizationUtil.toRange(interval);
            result.add(range);
        }
        return result;
    }
}

