/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.EvaluationException;

@Beta
public class ClassificationMap<K>
extends LinkedHashMap<K, Double>
implements Computable {
    private Type type = null;

    protected ClassificationMap(Type type) {
        this.setType(type);
    }

    @Override
    public Object getResult() {
        Map.Entry<K, Double> entry = this.getWinner();
        if (entry == null) {
            throw new EvaluationException();
        }
        return entry.getKey();
    }

    Double getFeature(String value) {
        Double result = (Double)this.get(value);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    Map.Entry<K, Double> getWinner() {
        Map.Entry result = null;
        Type type = this.getType();
        Set entries = this.entrySet();
        for (Map.Entry entry : entries) {
            if (result != null && type.compare((Double)entry.getValue(), (Double)result.getValue()) <= 0) continue;
            result = entry;
        }
        return result;
    }

    List<Map.Entry<K, Double>> getWinnerList() {
        ArrayList result = Lists.newArrayList(this.entrySet());
        final Type type = this.getType();
        Comparator comparator = new Comparator<Map.Entry<K, Double>>(){

            @Override
            public int compare(Map.Entry<K, Double> left, Map.Entry<K, Double> right) {
                return -1 * type.compare(left.getValue(), right.getValue());
            }
        };
        Collections.sort(result, comparator);
        return result;
    }

    List<K> getWinnerKeys() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, K>(){

            public K apply(Map.Entry<K, Double> entry) {
                return entry.getKey();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    List<Double> getWinnerValues() {
        List<Map.Entry<K, Double>> winners = this.getWinnerList();
        Function function = new Function<Map.Entry<K, Double>, Double>(){

            public Double apply(Map.Entry<K, Double> entry) {
                return entry.getValue();
            }
        };
        return Lists.transform(winners, (Function)function);
    }

    void normalizeValues() {
        ClassificationMap.normalize(this);
    }

    public Type getType() {
        return this.type;
    }

    private void setType(Type type) {
        this.type = type;
    }

    public static <K> Double sum(Map<K, Double> map) {
        return ClassificationMap.sum(map, null);
    }

    private static <K> Double sum(Map<K, Double> map, Function<Double, Double> function) {
        double sum = 0.0;
        Collection<Double> values = map.values();
        for (Double value : values) {
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            sum += value.doubleValue();
        }
        return sum;
    }

    public static <K> void normalize(Map<K, Double> map) {
        ClassificationMap.normalize(map, null);
    }

    public static <K> void normalizeSoftMax(Map<K, Double> map) {
        Function<Double, Double> function = new Function<Double, Double>(){

            public Double apply(Double value) {
                return Math.exp(value);
            }
        };
        ClassificationMap.normalize(map, function);
    }

    private static <K> void normalize(Map<K, Double> map, Function<Double, Double> function) {
        double sum = ClassificationMap.sum(map, function);
        Set<Map.Entry<K, Double>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Double value = (Double)entry.getValue();
            if (function != null) {
                value = (Double)function.apply((Object)value);
            }
            entry.setValue(value / sum);
        }
    }

    public static <K> void subtract(Map<K, Double> map, List<K> keys) {
        double offset = 0.0;
        for (int i = 0; i < keys.size() - 1; ++i) {
            K key = keys.get(i);
            Double cumulativeProbability = map.get(key);
            if (cumulativeProbability == null || cumulativeProbability > 1.0) {
                throw new EvaluationException();
            }
            Double probability = cumulativeProbability - offset;
            if (probability < 0.0) {
                throw new EvaluationException();
            }
            map.put(key, probability);
            offset = cumulativeProbability;
        }
        if (keys.size() > 1) {
            K key = keys.get(keys.size() - 1);
            map.put(key, 1.0 - offset);
        }
    }

    public static enum Type implements Comparator<Double>
    {
        PROBABILITY(Ordering.INCREASING),
        CONFIDENCE(Ordering.INCREASING),
        DISTANCE(Ordering.DECREASING),
        SIMILARITY(Ordering.INCREASING),
        VOTE(Ordering.INCREASING);

        private Ordering ordering;

        private Type(Ordering ordering) {
            this.setOrdering(ordering);
        }

        @Override
        public int compare(Double left, Double right) {
            if (left == null || right == null) {
                throw new EvaluationException();
            }
            int order = left.compareTo(right);
            Ordering ordering = this.getOrdering();
            switch (ordering) {
                case INCREASING: {
                    return order;
                }
                case DECREASING: {
                    return -1 * order;
                }
            }
            throw new IllegalStateException();
        }

        public Ordering getOrdering() {
            return this.ordering;
        }

        private void setOrdering(Ordering ordering) {
            this.ordering = ordering;
        }

        private static enum Ordering {
            INCREASING,
            DECREASING;

        }
    }
}

