/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableBiMap;
import java.util.List;
import org.dmg.pmml.HasId;
import org.dmg.pmml.PMMLObject;
import org.jpmml.manager.InvalidFeatureException;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <E extends PMMLObject> ImmutableBiMap<String, E> buildBiMap(List<E> entities) {
        ImmutableBiMap.Builder<String, E> builder = new ImmutableBiMap.Builder<String, E>();
        builder = EntityUtil.putAll(entities, builder);
        return builder.build();
    }

    public static <E extends PMMLObject> ImmutableBiMap.Builder<String, E> put(E entity, ImmutableBiMap.Builder<String, E> builder) {
        String id = ((HasId)entity).getId();
        if (id == null) {
            throw new InvalidFeatureException(entity);
        }
        return builder.put((Object)id, entity);
    }

    public static <E extends PMMLObject> ImmutableBiMap.Builder<String, E> putAll(List<E> entities, ImmutableBiMap.Builder<String, E> builder) {
        int i = 0;
        int j = 1;
        while (i < entities.size()) {
            PMMLObject entity = (PMMLObject)entities.get(i);
            String id = ((HasId)entity).getId();
            if (id == null) {
                id = String.valueOf(j);
            }
            builder = builder.put((Object)id, (Object)entity);
            ++i;
            ++j;
        }
        return builder;
    }
}

