/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethodType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethodType;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidResultException;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentUtilTest {
    @Test
    public void prepare() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
        MiningField miningField = new MiningField(name);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "1"));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, Float.valueOf(1.0f)));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Value missingValue = ArgumentUtilTest.createValue("N/A", Value.Property.MISSING);
        dataField = dataField.withValues(new Value[]{missingValue});
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals(null, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        miningField = miningField.withMissingValueReplacement("0");
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, null));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, "N/A"));
        Interval validInterval = new Interval(Interval.Closure.CLOSED_CLOSED).withLeftMargin(Double.valueOf(1.0)).withRightMargin(Double.valueOf(3.0));
        dataField = dataField.withIntervals(new Interval[]{validInterval});
        miningField = miningField.withOutlierTreatment(OutlierTreatmentMethodType.AS_IS).withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)-1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField = miningField.withOutlierTreatment(OutlierTreatmentMethodType.AS_MISSING_VALUES).withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField = miningField.withOutlierTreatment(OutlierTreatmentMethodType.AS_EXTREME_VALUES).withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS).withLowValue(Double.valueOf(1.0)).withHighValue(Double.valueOf(3.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)3.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField = miningField.withOutlierTreatment(OutlierTreatmentMethodType.AS_MISSING_VALUES).withInvalidValueTreatment(InvalidValueTreatmentMethodType.RETURN_INVALID).withLowValue(null).withHighValue(null);
        try {
            ArgumentUtilTest.prepare(dataField, miningField, -1.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        try {
            ArgumentUtilTest.prepare(dataField, miningField, 5.0);
            Assert.fail();
        }
        catch (InvalidResultException ire) {
            // empty catch block
        }
        miningField = miningField.withOutlierTreatment(OutlierTreatmentMethodType.AS_IS).withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, -1.0));
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        dataField = ArgumentUtilTest.clear(dataField);
        dataField = dataField.withValues(new Value[]{missingValue, ArgumentUtilTest.createValue("1", Value.Property.VALID), ArgumentUtilTest.createValue("2", Value.Property.VALID), ArgumentUtilTest.createValue("3", Value.Property.VALID)});
        miningField = miningField.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField = miningField.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        dataField = ArgumentUtilTest.clear(dataField);
        dataField = dataField.withValues(new Value[]{missingValue, ArgumentUtilTest.createValue("1", Value.Property.INVALID)});
        miningField = miningField.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_IS);
        Assert.assertEquals((Object)1.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
        miningField = miningField.withInvalidValueTreatment(InvalidValueTreatmentMethodType.AS_MISSING);
        Assert.assertEquals((Object)0.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 1.0));
        Assert.assertEquals((Object)5.0, (Object)ArgumentUtilTest.prepare(dataField, miningField, 5.0));
    }

    @Test
    public void isOutlier() {
        FieldName name = new FieldName("x");
        DataField dataField = new DataField(name, OpType.CONTINUOUS, DataType.DOUBLE).withIntervals(new Interval[]{ArgumentUtilTest.createInterval(Interval.Closure.CLOSED_CLOSED, -10.0, -1.0), ArgumentUtilTest.createInterval(Interval.Closure.CLOSED_CLOSED, 1.0, 10.0)});
        Assert.assertTrue((boolean)ArgumentUtil.isOutlier((DataField)dataField, (Object)-15.0));
        Assert.assertFalse((boolean)ArgumentUtil.isOutlier((DataField)dataField, (Object)0.0));
        Assert.assertTrue((boolean)ArgumentUtil.isOutlier((DataField)dataField, (Object)15.0));
    }

    @Test
    public void isInvalid() {
        Assert.assertFalse((boolean)ArgumentUtil.isInvalid(null, null));
    }

    @Test
    public void isValid() {
        Assert.assertFalse((boolean)ArgumentUtil.isValid(null, null));
    }

    private static Object prepare(DataField dataField, MiningField miningField, Object value) {
        FieldValue result = ArgumentUtil.prepare((DataField)dataField, (MiningField)miningField, (Object)value);
        return FieldValueUtil.getValue((FieldValue)result);
    }

    private static DataField clear(DataField dataField) {
        List intervals = dataField.getIntervals();
        intervals.clear();
        List values = dataField.getValues();
        values.clear();
        return dataField;
    }

    private static Interval createInterval(Interval.Closure closure, Double leftMargin, Double rightMargin) {
        Interval result = new Interval(closure).withLeftMargin(leftMargin).withRightMargin(rightMargin);
        return result;
    }

    private static Value createValue(String value, Value.Property property) {
        Value result = new Value(value).withProperty(property);
        return result;
    }
}

