/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldUsageType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.manager.ModelManager;

public abstract class ModelEvaluator<M extends Model>
extends ModelManager<M>
implements Evaluator {
    private static final EnumSet<FieldUsageType> FILTER_SET = EnumSet.of(FieldUsageType.ACTIVE, FieldUsageType.GROUP, FieldUsageType.ORDER);

    public ModelEvaluator(PMML pmml, M model) {
        super(pmml, model);
    }

    public abstract Map<FieldName, ?> evaluate(ModelEvaluationContext var1);

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        DataField dataField = this.getDataField(name);
        MiningField miningField = this.getMiningField(name);
        if (dataField == null || miningField == null) {
            throw new EvaluationException();
        }
        return ArgumentUtil.prepare(dataField, miningField, value);
    }

    public ModelEvaluationContext createContext(ModelEvaluationContext parent) {
        return new ModelEvaluationContext(parent, this);
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        List filterFields = this.getMiningFields(FILTER_SET);
        ModelEvaluationContext context = this.createContext(null);
        context.declareAll(arguments, (Set<FieldName>)ImmutableSet.copyOf((Collection)filterFields));
        return this.evaluate(context);
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        Model model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }

    public <V> V getValue(Callable<? extends V> loader, Cache<M, V> cache) {
        Model model = this.getModel();
        return CacheUtil.getValue(model, loader, cache);
    }
}

