/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.AssociationRule;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Item;
import org.dmg.pmml.ItemRef;
import org.dmg.pmml.Itemset;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeatureType;
import org.dmg.pmml.RuleFeatureType;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.ArgumentUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasClusterAffinity;
import org.jpmml.evaluator.HasClusterId;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.MiningModelEvaluationContext;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ResultFeature;
import org.jpmml.evaluator.SegmentResultMap;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeAnalysisException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, ?> evaluate(Map<FieldName, ?> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Output output = modelEvaluator.getOutput();
        if (output == null) {
            return predictions;
        }
        LinkedHashMap result = Maps.newLinkedHashMap(predictions);
        List outputFields = output.getOutputFields();
        block30: for (OutputField outputField : outputFields) {
            SegmentResultMap segmentPredictions = predictions;
            String segmentId = outputField.getSegmentId();
            if (segmentId != null) {
                MiningModelEvaluationContext miningModelContext = (MiningModelEvaluationContext)context;
                segmentPredictions = miningModelContext.getResult(segmentId);
            }
            if (segmentPredictions == null) continue;
            FieldName targetField = outputField.getTargetField();
            if (targetField == null) {
                targetField = modelEvaluator.getTargetField();
            }
            Object value = null;
            ResultFeatureType resultFeature = OutputUtil.getResultFeatureType(outputField);
            switch (resultFeature) {
                case ENTITY_ID: {
                    if (OutputUtil.isSegmentId(segmentPredictions, outputField)) break;
                }
                case PREDICTED_VALUE: 
                case PREDICTED_DISPLAY_VALUE: 
                case PROBABILITY: 
                case RESIDUAL: 
                case CLUSTER_ID: 
                case AFFINITY: 
                case ENTITY_AFFINITY: 
                case CLUSTER_AFFINITY: 
                case REASON_CODE: 
                case RULE_VALUE: 
                case ANTECEDENT: 
                case CONSEQUENT: 
                case RULE: 
                case RULE_ID: 
                case CONFIDENCE: 
                case SUPPORT: 
                case LIFT: 
                case LEVERAGE: {
                    if (!segmentPredictions.containsKey(targetField)) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    value = segmentPredictions.get(targetField);
                    if (value != null) break;
                    continue block30;
                }
            }
            block4 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getPredictedValue(value);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    Target target = modelEvaluator.getTarget(targetField);
                    DataField dataField = modelEvaluator.getDataField(targetField);
                    value = OutputUtil.getPredictedDisplayValue(value, target, dataField);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    if (segmentId != null) {
                        throw new UnsupportedFeatureException((PMMLObject)outputField);
                    }
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException((PMMLObject)outputField);
                    }
                    value = FieldValueUtil.getValue(ExpressionUtil.evaluate(expression, (EvaluationContext)context));
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(value, outputField);
                    break;
                }
                case RESIDUAL: {
                    FieldValue expectedValue = context.getField(targetField);
                    if (expectedValue == null) {
                        throw new MissingFieldException(targetField, (PMMLObject)outputField);
                    }
                    DataField dataField = modelEvaluator.getDataField(targetField);
                    OpType opType = dataField.getOptype();
                    switch (opType) {
                        case CONTINUOUS: {
                            value = OutputUtil.getContinuousResidual(value, expectedValue);
                            break block4;
                        }
                        case CATEGORICAL: {
                            value = OutputUtil.getCategoricalResidual(value, expectedValue);
                            break block4;
                        }
                    }
                    throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum)opType);
                }
                case ENTITY_ID: {
                    if (OutputUtil.isSegmentId(segmentPredictions, outputField)) {
                        SegmentResultMap segmentResult = segmentPredictions;
                        value = segmentResult.getId();
                        break;
                    }
                    value = OutputUtil.getEntityId(value, outputField);
                    break;
                }
                case CLUSTER_ID: {
                    value = OutputUtil.getClusterId(value);
                    break;
                }
                case AFFINITY: 
                case ENTITY_AFFINITY: {
                    value = OutputUtil.getAffinity(value, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: {
                    value = OutputUtil.getClusterAffinity(value);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(value, outputField);
                    break;
                }
                case RULE_VALUE: {
                    value = OutputUtil.getRuleValue(value, outputField);
                    break;
                }
                case ANTECEDENT: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.ANTECEDENT);
                    break;
                }
                case CONSEQUENT: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.CONSEQUENT);
                    break;
                }
                case RULE: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.RULE);
                    break;
                }
                case RULE_ID: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.RULE_ID);
                    break;
                }
                case CONFIDENCE: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.CONFIDENCE);
                    break;
                }
                case SUPPORT: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.SUPPORT);
                    break;
                }
                case LIFT: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.LIFT);
                    break;
                }
                case LEVERAGE: {
                    value = OutputUtil.getRuleValue(value, outputField, RuleFeatureType.LEVERAGE);
                    break;
                }
                case WARNING: {
                    value = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)resultFeature);
                }
            }
            context.declare(outputField.getName(), FieldValueUtil.create((Field)outputField, value));
            result.put(outputField.getName(), value);
        }
        return result;
    }

    public static DataType getDataType(OutputField outputField, ModelEvaluator<?> modelEvaluator) {
        DataType dataType = outputField.getDataType();
        if (dataType != null) {
            return dataType;
        }
        String segmentId = outputField.getSegmentId();
        if (segmentId != null) {
            throw new TypeAnalysisException((PMMLObject)outputField);
        }
        ResultFeatureType resultFeature = OutputUtil.getResultFeatureType(outputField);
        switch (resultFeature) {
            case PREDICTED_VALUE: {
                FieldName targetField = outputField.getTargetField();
                if (targetField == null) {
                    targetField = modelEvaluator.getTargetField();
                }
                DataField dataField = modelEvaluator.getDataField(targetField);
                return dataField.getDataType();
            }
            case PREDICTED_DISPLAY_VALUE: {
                return DataType.STRING;
            }
            case TRANSFORMED_VALUE: 
            case DECISION: {
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
            case PROBABILITY: 
            case RESIDUAL: 
            case STANDARD_ERROR: {
                return DataType.DOUBLE;
            }
            case ENTITY_ID: 
            case CLUSTER_ID: {
                return DataType.STRING;
            }
            case AFFINITY: 
            case ENTITY_AFFINITY: 
            case CLUSTER_AFFINITY: {
                return DataType.DOUBLE;
            }
            case REASON_CODE: {
                return DataType.STRING;
            }
            case RULE_VALUE: {
                return OutputUtil.getRuleDataType(outputField);
            }
            case ANTECEDENT: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.ANTECEDENT);
            }
            case CONSEQUENT: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.CONSEQUENT);
            }
            case RULE: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.RULE);
            }
            case RULE_ID: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.RULE_ID);
            }
            case SUPPORT: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.SUPPORT);
            }
            case CONFIDENCE: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.CONFIDENCE);
            }
            case LIFT: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.LIFT);
            }
            case LEVERAGE: {
                return OutputUtil.getRuleDataType(outputField, RuleFeatureType.LEVERAGE);
            }
            case WARNING: {
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)resultFeature);
    }

    private static ResultFeatureType getResultFeatureType(OutputField outputField) {
        ResultFeatureType resultFeature = outputField.getFeature();
        if (resultFeature == null) {
            resultFeature = ResultFeatureType.PREDICTED_VALUE;
        }
        return resultFeature;
    }

    private static boolean isSegmentId(Map<FieldName, ?> predictions, OutputField outputField) {
        FieldName targetField = outputField.getTargetField();
        if (targetField == null) {
            return predictions instanceof SegmentResultMap;
        }
        return false;
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, Target target, DataField dataField) {
        String displayValue;
        Value value;
        String displayValue2;
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = OutputUtil.asResultFeature(HasDisplayValue.class, object);
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null && (displayValue2 = targetValue.getDisplayValue()) != null) {
            return displayValue2;
        }
        OpType opType = dataField.getOptype();
        if ((OpType.CATEGORICAL.equals((Object)opType) || OpType.ORDINAL.equals((Object)opType)) && (value = ArgumentUtil.getValidValue((TypeDefinitionField)dataField, object)) != null && (displayValue = value.getDisplayValue()) != null) {
            return displayValue;
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        HasProbability hasProbability = OutputUtil.asResultFeature(HasProbability.class, object);
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasProbability.getProbability(value);
    }

    private static String getCategoryValue(Object object, OutputField outputField) {
        String value = outputField.getValue();
        if (value == null) {
            return TypeUtil.format(OutputUtil.getPredictedValue(object));
        }
        return value;
    }

    private static Double getContinuousResidual(Object object, FieldValue expectedObject) {
        Number value = (Number)OutputUtil.getPredictedValue(object);
        Number expectedValue = (Number)FieldValueUtil.getValue(expectedObject);
        return expectedValue.doubleValue() - value.doubleValue();
    }

    public static Double getCategoricalResidual(Object object, FieldValue expectedObject) {
        String expectedValue;
        HasProbability hasProbability = OutputUtil.asResultFeature(HasProbability.class, object);
        String value = TypeUtil.format(OutputUtil.getPredictedValue(object));
        boolean equals = TypeUtil.equals(DataType.STRING, value, expectedValue = TypeUtil.format(FieldValueUtil.getValue(expectedObject)));
        return (equals ? 1.0 : 0.0) - hasProbability.getProbability(value);
    }

    private static String getEntityId(Object object, OutputField outputField) {
        HasEntityId hasEntityId = OutputUtil.asResultFeature(HasEntityId.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        if (rank > 1) {
            HasEntityIdRanking hasEntityIdRanking = OutputUtil.asResultFeature(HasEntityIdRanking.class, object);
            return OutputUtil.getElement(hasEntityIdRanking.getEntityIdRanking(), rank);
        }
        return hasEntityId.getEntityId();
    }

    private static String getClusterId(Object object) {
        HasClusterId hasClusterId = OutputUtil.asResultFeature(HasClusterId.class, object);
        return hasClusterId.getClusterId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        HasAffinity hasAffinity = OutputUtil.asResultFeature(HasAffinity.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        if (rank > 1) {
            HasAffinityRanking hasAffinityRanking = OutputUtil.asResultFeature(HasAffinityRanking.class, object);
            return OutputUtil.getElement(hasAffinityRanking.getAffinityRanking(), rank);
        }
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasAffinity.getAffinity(value);
    }

    public static Double getClusterAffinity(Object object) {
        HasClusterAffinity hasClusterAffinity = OutputUtil.asResultFeature(HasClusterAffinity.class, object);
        return hasClusterAffinity.getClusterAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        HasReasonCodeRanking hasReasonCodeRanking = OutputUtil.asResultFeature(HasReasonCodeRanking.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        return OutputUtil.getElement(hasReasonCodeRanking.getReasonCodeRanking(), rank);
    }

    public static Object getRuleValue(Object object, OutputField outputField, RuleFeatureType ruleFeature) {
        HasRuleValues hasRuleValues = OutputUtil.asResultFeature(HasRuleValues.class, object);
        List<AssociationRule> associationRules = hasRuleValues.getRuleValues(outputField.getAlgorithm());
        OutputUtil.sortRules(associationRules, outputField);
        String isMultiValued = outputField.getIsMultiValued();
        if (!"0".equals(isMultiValued)) {
            throw new UnsupportedFeatureException((PMMLObject)outputField);
        }
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
        if (associationRule != null) {
            return OutputUtil.getRuleFeature(hasRuleValues, associationRule, (PMMLObject)outputField, ruleFeature);
        }
        return null;
    }

    public static Object getRuleValue(Object object, OutputField outputField) {
        HasRuleValues hasRuleValues = OutputUtil.asResultFeature(HasRuleValues.class, object);
        List<AssociationRule> associationRules = hasRuleValues.getRuleValues(outputField.getAlgorithm());
        OutputUtil.sortRules(associationRules, outputField);
        String isMultiValued = outputField.getIsMultiValued();
        if ("0".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank <= 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
            if (associationRule != null) {
                return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField);
            }
            return null;
        }
        if ("1".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank < 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
            associationRules = associationRules.subList(0, size);
            ArrayList result = Lists.newArrayList();
            for (AssociationRule associationRule : associationRules) {
                result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField));
            }
            return result;
        }
        throw new InvalidFeatureException((PMMLObject)outputField);
    }

    private static void sortRules(List<AssociationRule> associationRules, final OutputField outputField) {
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                int order;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        order = this.getConfidence(left).compareTo(this.getConfidence(right));
                        break;
                    }
                    case SUPPORT: {
                        order = this.getSupport(left).compareTo(this.getSupport(right));
                        break;
                    }
                    case LIFT: {
                        order = this.getLift(left).compareTo(this.getLift(right));
                        break;
                    }
                    case LEVERAGE: {
                        order = this.getLeverage(left).compareTo(this.getLeverage(right));
                        break;
                    }
                    case AFFINITY: {
                        order = this.getAffinity(left).compareTo(this.getAffinity(right));
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)this.rankBasis);
                    }
                }
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)this.rankOrder);
            }

            private Double getConfidence(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getConfidence());
            }

            private Double getSupport(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getSupport());
            }

            private Double getLift(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getLift());
            }

            private Double getLeverage(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getLeverage());
            }

            private Double getAffinity(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getAffinity());
            }

            private <V> V checkRuleFeature(AssociationRule rule, V value) {
                if (value == null) {
                    throw new InvalidFeatureException((PMMLObject)rule);
                }
                return value;
            }
        };
        Collections.sort(associationRules, comparator);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField) {
        return OutputUtil.getRuleFeature(hasRuleValues, associationRule, (PMMLObject)outputField, outputField.getRuleFeature());
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, PMMLObject element, RuleFeatureType ruleFeature) {
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on((char)',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                String id = associationRule.getId();
                if (id == null) {
                    BiMap<String, AssociationRule> associationRuleRegistry = hasRuleValues.getAssociationRuleRegistry();
                    id = (String)associationRuleRegistry.inverse().get((Object)associationRule);
                }
                return id;
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedFeatureException(element, (Enum)ruleFeature);
    }

    private static DataType getRuleDataType(OutputField outputField) {
        return OutputUtil.getRuleDataType(outputField, outputField.getRuleFeature());
    }

    private static DataType getRuleDataType(OutputField outputField, RuleFeatureType ruleFeature) {
        String isMultiValued = outputField.getIsMultiValued();
        if (!"0".equals(isMultiValued)) {
            throw new TypeAnalysisException((PMMLObject)outputField);
        }
        switch (ruleFeature) {
            case ANTECEDENT: 
            case CONSEQUENT: {
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
            case RULE: 
            case RULE_ID: {
                return DataType.STRING;
            }
            case CONFIDENCE: 
            case SUPPORT: 
            case LIFT: 
            case LEVERAGE: 
            case AFFINITY: {
                return DataType.DOUBLE;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum)ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        ArrayList result = Lists.newArrayList();
        BiMap<String, Item> itemRegistry = hasRuleValues.getItemRegistry();
        BiMap<String, Itemset> itemsetRegistry = hasRuleValues.getItemsetRegistry();
        Itemset itemset = (Itemset)itemsetRegistry.get((Object)id);
        List itemRefs = itemset.getItemRefs();
        for (ItemRef itemRef : itemRefs) {
            Item item = (Item)itemRegistry.get((Object)itemRef.getItemRef());
            result.add(item.getValue());
        }
        return result;
    }

    private static <E extends ResultFeature> E asResultFeature(Class<? extends E> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new TypeCheckException(clazz, object);
        }
        return (E)((ResultFeature)clazz.cast(object));
    }

    private static <E> E getElement(List<E> elements, int rank) {
        int index = rank - 1;
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }
}

