/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MissingValueStrategyType;
import org.dmg.pmml.NoTrueChildStrategyType;
import org.dmg.pmml.Node;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.TreeModel;
import org.jpmml.evaluator.ClassificationMap;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NodeClassificationMap;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.manager.InvalidFeatureException;
import org.jpmml.manager.UnsupportedFeatureException;

public class TreeModelEvaluator
extends ModelEvaluator<TreeModel>
implements HasEntityRegistry<Node> {
    private static final LoadingCache<TreeModel, BiMap<String, Node>> entityCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<TreeModel, BiMap<String, Node>>(){

        public BiMap<String, Node> load(TreeModel treeModel) {
            ImmutableBiMap.Builder<String, Node> builder = new ImmutableBiMap.Builder<String, Node>();
            builder = this.collectNodes(treeModel.getNode(), builder);
            return builder.build();
        }

        private ImmutableBiMap.Builder<String, Node> collectNodes(Node node, ImmutableBiMap.Builder<String, Node> builder) {
            builder = EntityUtil.put(node, builder);
            List children = node.getNodes();
            for (Node child : children) {
                builder = this.collectNodes(child, builder);
            }
            return builder;
        }
    });

    public TreeModelEvaluator(PMML pmml) {
        this(pmml, (TreeModel)TreeModelEvaluator.find((List)pmml.getModels(), TreeModel.class));
    }

    public TreeModelEvaluator(PMML pmml, TreeModel treeModel) {
        super(pmml, treeModel);
    }

    public String getSummary() {
        return "Tree model";
    }

    @Override
    public BiMap<String, Node> getEntityRegistry() {
        return this.getValue(entityCache);
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Serializable> predictions;
        TreeModel treeModel = (TreeModel)this.getModel();
        if (!treeModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)treeModel);
        }
        MiningFunctionType miningFunction = treeModel.getFunctionName();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)treeModel, (Enum)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ? extends Number> evaluateRegression(ModelEvaluationContext context) {
        Double result = null;
        Trail trail = new Trail();
        Node node = this.evaluateTree(trail, context);
        if (node != null) {
            String score = TreeModelEvaluator.ensureScore(node);
            result = (Double)TypeUtil.parseOrCast(DataType.DOUBLE, score);
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ? extends ClassificationMap<?>> evaluateClassification(ModelEvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        NodeClassificationMap result = null;
        Trail trail = new Trail();
        Node node = this.evaluateTree(trail, context);
        if (node != null) {
            TreeModelEvaluator.ensureScore(node);
            double missingValuePenalty = 1.0;
            int missingLevels = trail.getMissingLevels();
            for (int i = 0; i < missingLevels; ++i) {
                missingValuePenalty *= treeModel.getMissingValuePenalty();
            }
            result = TreeModelEvaluator.createNodeClassificationMap(node, missingValuePenalty);
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Node evaluateTree(Trail trail, ModelEvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        Node root = treeModel.getNode();
        if (root == null) {
            throw new InvalidFeatureException((PMMLObject)treeModel);
        }
        Boolean status = this.evaluateNode(root, trail, context);
        if (status != null && status.booleanValue()) {
            NodeResult result = this.handleTrue(root, trail, context);
            return result.getNode();
        }
        return null;
    }

    private Boolean evaluateNode(Node node, Trail trail, EvaluationContext context) {
        EmbeddedModel embeddedModel = node.getEmbeddedModel();
        if (embeddedModel != null) {
            throw new UnsupportedFeatureException((PMMLObject)embeddedModel);
        }
        Predicate predicate = node.getPredicate();
        if (predicate == null) {
            throw new InvalidFeatureException((PMMLObject)node);
        }
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            PredicateUtil.CompoundPredicateResult result = PredicateUtil.evaluateCompoundPredicateInternal(compoundPredicate, context);
            if (result.isAlternative()) {
                trail.addMissingLevel();
            }
            return result.getResult();
        }
        return PredicateUtil.evaluate(predicate, context);
    }

    private NodeResult handleTrue(Node node, Trail trail, EvaluationContext context) {
        List children = node.getNodes();
        if (children.isEmpty()) {
            return new NodeResult(node);
        }
        trail.push(node);
        for (Node child : children) {
            Boolean status = this.evaluateNode(child, trail, context);
            if (status == null) {
                NodeResult result = this.handleMissingValue(node, child, trail, context);
                if (result == null) continue;
                return result;
            }
            if (!status.booleanValue()) continue;
            return this.handleTrue(child, trail, context);
        }
        return this.handleNoTrueChild(node, trail, context);
    }

    private NodeResult handleDefaultChild(Node node, Trail trail, EvaluationContext context) {
        List children = node.getNodes();
        String defaultChild = node.getDefaultChild();
        if (defaultChild == null) {
            throw new InvalidFeatureException((PMMLObject)node);
        }
        trail.addMissingLevel();
        for (Node child : children) {
            String id = child.getId();
            if (id == null || !id.equals(defaultChild)) continue;
            return this.handleTrue(child, trail, context);
        }
        throw new InvalidFeatureException((PMMLObject)node);
    }

    private NodeResult handleNoTrueChild(Node node, Trail trail, EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        NoTrueChildStrategyType noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        switch (noTrueChildStrategy) {
            case RETURN_NULL_PREDICTION: {
                return new NodeResult(null);
            }
            case RETURN_LAST_PREDICTION: {
                Node parent;
                if (trail.size() > 0 && (parent = trail.getLastPrediction()).getScore() != null) {
                    return new NodeResult(parent);
                }
                return new NodeResult(null);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)treeModel, (Enum)noTrueChildStrategy);
    }

    private NodeResult handleMissingValue(Node parent, Node node, Trail trail, EvaluationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        MissingValueStrategyType missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case NULL_PREDICTION: {
                return new NodeResult(null);
            }
            case LAST_PREDICTION: {
                return new NodeResult(trail.getLastPrediction());
            }
            case DEFAULT_CHILD: {
                if (parent == null) {
                    throw new EvaluationException();
                }
                return this.handleDefaultChild(parent, trail, context);
            }
            case NONE: {
                return null;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)treeModel, (Enum)missingValueStrategy);
    }

    private static String ensureScore(Node node) {
        String score = node.getScore();
        if (score == null) {
            throw new InvalidFeatureException((PMMLObject)node);
        }
        return score;
    }

    private static NodeClassificationMap createNodeClassificationMap(Node node, double missingValuePenalty) {
        NodeClassificationMap result = new NodeClassificationMap(node);
        List scoreDistributions = node.getScoreDistributions();
        double sum = 0.0;
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            sum += scoreDistribution.getRecordCount();
        }
        for (ScoreDistribution scoreDistribution : scoreDistributions) {
            Double probability = scoreDistribution.getProbability();
            if (probability == null) {
                probability = scoreDistribution.getRecordCount() / sum;
            }
            result.put(scoreDistribution.getValue(), probability);
            Double confidence = scoreDistribution.getConfidence();
            if (confidence == null) continue;
            result.putConfidence(scoreDistribution.getValue(), confidence * missingValuePenalty);
        }
        return result;
    }

    private static class NodeResult {
        private Node node = null;

        public NodeResult(Node node) {
            this.setNode(node);
        }

        public Node getNode() {
            return this.node;
        }

        private void setNode(Node node) {
            this.node = node;
        }
    }

    private static class Trail
    extends ArrayDeque<Node> {
        private int missingLevels = 0;

        public Node getLastPrediction() {
            return (Node)this.getFirst();
        }

        public void addMissingLevel() {
            this.setMissingLevels(this.getMissingLevels() + 1);
        }

        public int getMissingLevels() {
            return this.missingLevels;
        }

        private void setMissingLevels(int missingLevels) {
            this.missingLevels = missingLevels;
        }
    }
}

