/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;

public class CsvUtil {
    private CsvUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<FieldName, String>> load(InputStream is) throws IOException {
        ArrayList table = Lists.newArrayList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
        try {
            String bodyLine;
            String headerLine = reader.readLine();
            if (headerLine == null) {
                throw new EOFException();
            }
            List<String> headerCells = CsvUtil.parseLine(headerLine);
            while ((bodyLine = reader.readLine()) != null) {
                LinkedHashMap row = Maps.newLinkedHashMap();
                List<String> bodyCells = CsvUtil.parseLine(bodyLine);
                if (headerCells.size() != bodyCells.size()) {
                    throw new RuntimeException();
                }
                for (int i = 0; i < headerCells.size(); ++i) {
                    row.put(FieldName.create((String)headerCells.get(i)), bodyCells.get(i));
                }
                table.add(row);
            }
        }
        finally {
            reader.close();
        }
        return table;
    }

    public static List<String> parseLine(String line) {
        List<String> cells = Arrays.asList(line.split(","));
        Function<String, String> function = new Function<String, String>(){

            public String apply(String cell) {
                if ("NA".equals(cell) || "N/A".equals(cell)) {
                    return null;
                }
                return cell;
            }
        };
        return Lists.transform(cells, (Function)function);
    }
}

